package cn.gtmap.hlw.core.annotation;

import java.lang.reflect.Field;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2023/12/11
 * @description 实体字段默认值设置
 */
public class DefauleValueFactory {
    public static <T> T create(Class<T> t)  {
        T t1 = null;
        try {
            t1 = t.newInstance();
        } catch (InstantiationException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        Field[] fields = t1.getClass().getDeclaredFields();
        for (Field field:fields) {
            if(field.isAnnotationPresent(DefaultValueConfig.class)){
                DefaultValueConfig annotation = field.getAnnotation(DefaultValueConfig.class);
                try {
                    field.setAccessible(true);
                    Class<?> type = field.getType();
                    Object obj=null;
                    if(type == Integer.class){
                        obj = Integer.valueOf(annotation.value());
 
                    }
                    if(type==String.class){
                        obj=annotation.value();
                    }
                    field.set(t1,obj);
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return t1;
 
    }
}