/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.wxjj;

import cn.hutool.core.codec.Base64Decoder;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSignature {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Signature signa = null;
    private String sign_algorithm = "MD5WithRSA";

    public HttpSignature() {
        if (this.signa == null) {
            try {
                this.signa = Signature.getInstance(this.sign_algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.error("\u6ca1\u6709\u8fd9\u4e2a\u7b97\u6cd5\u7684\u7b7e\u540d\u5bf9\u8c61\uff1a" + this.sign_algorithm, (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error("\u521b\u5efa\u52a0\u7b7e\u540d\u5bf9\u8c61\u65f6\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
            }
        }
    }

    public byte[] sign(byte[] in, String key) throws Exception {
        byte[] signdata = null;
        PrivateKey pri_key = this.getPrivateKey(key);
        try {
            this.signa.initSign(pri_key);
            this.signa.update(in);
            signdata = this.signa.sign();
        }
        catch (InvalidKeyException e) {
            this.logger.error("\u521d\u59cb\u5316\u7b7e\u540d\u5bf9\u8c61\u51fa\u73b0\u5f02\u5e38\uff0c\u670d\u52a1\u5668\u8bc1\u4e66\u79c1\u94a5\u4e0d\u6b63\u786e!", (Throwable)e);
            throw new Exception("\u521d\u59cb\u5316\u7b7e\u540d\u5bf9\u8c61\u51fa\u73b0\u5f02\u5e38\uff0c\u670d\u52a1\u5668\u8bc1\u4e66\u79c1\u94a5\u4e0d\u6b63\u786e!");
        }
        catch (SignatureException e) {
            this.logger.error("\u8fdb\u884c\u6570\u5b57\u7b7e\u540d\u65f6\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
            throw new Exception("\u8fdb\u884c\u6570\u5b57\u7b7e\u540d\u65f6\u51fa\u73b0\u5f02\u5e38!");
        }
        catch (Exception e) {
            throw new Exception("\u6570\u5b57\u7b7e\u540d\u51fa\u73b0\u5f02\u5e38!");
        }
        return signdata;
    }

    private PrivateKey getPrivateKey(String pri_key) {
        PrivateKey privateKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(Base64Decoder.decode((CharSequence)pri_key)));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return privateKey;
    }
}

