package cn.gtmap.hlw.core.util.es;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a
 * @version 1.0, 2025/4/23
 * @description 通用的 Pair 类，兼容 JDK 1.8，可用于键值对、方法返回值等场景。
 */
public class Pair <K, V> implements Serializable {
    private static final long serialVersionUID = 1L;

    private final K key;
    private final V value;

    public Pair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return key;
    }

    public V getValue() {
        return value;
    }

    @Override
    public String toString() {
        return "(" + key + ", " + value + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Pair)) return false;
        Pair<?, ?> pair = (Pair<?, ?>) o;
        return Objects.equals(key, pair.key) &&
                Objects.equals(value, pair.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, value);
    }
}
