package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.BasePage;
import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.model.GxYyRole;

import java.util.List;

/**
 * (GxYyRole)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-27 17:33:44
 */
public interface GxYyRoleRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param roleId 主键
     * @return 实例对象
     */
    GxYyRole get(String roleId);

    /**
     * 新增数据
     *
     * @param gxYyRole 实例对象
     * @return 影响行数
     */
    void save(GxYyRole gxYyRole);

    /**
     * 修改数据
     *
     * @param gxYyRole 实例对象
     * @return 影响行数
     */
    void update(GxYyRole gxYyRole);

    /**
     * 修改数据
     *
     * @param roleIdList 角色id集合
     * @return 影响行数
     */
    List<GxYyRole> getRoleList(List<String> roleIdList);

    /**
     * 获取数据
     *
     * @return 影响行数
     */
    List<GxYyRole> getAll();

    /**
     * 删除数据
     *
     * @param roleId
     * @return 影响行数
     */
    int delete(String roleId);

    /**
     * 分页查询
     *
     * @param roleId 接收人
     * @param page
     * @return 影响行数
     */
    PageInfo<GxYyRole> queryPage(String roleId, BasePage page);

    /**
     * 根据用户ID去redis里获取角色名称
     *
     * @param ssyhlx
     * @return
     */
    String getRedisRoleNameByRoleId(String ssyhlx);
}

