package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxSw;

import java.util.List;

/**
 * 申请信息——税务表(GxYySqxxSw)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:50
 */
public interface GxYySqxxSwRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param guid 主键
     * @return 实例对象
     */
    GxYySqxxSw get(String guid);

    /**
     * 通过slbh查询数据集合
     *
     * @param slbh 受理编号
     * @return 实例对象
     */
    List<GxYySqxxSw> list(String slbh);

    /**
     * 新增数据
     *
     * @param gxYySqxxSw 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxSw gxYySqxxSw);

    /**
     * 修改数据
     *
     * @param gxYySqxxSw 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxSw gxYySqxxSw);

    /**
     * 新增或修改数据
     *
     * @param gxYySqxxSw 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYySqxxSw gxYySqxxSw);

    /**
     * 通过sqidList查询集合数据
     *
     * @param sqidList
     * @return 实例对象
     */
    List<GxYySqxxSw> getBySqidList(List<String> sqidList);

    /**
     * 通过sqidList删除数据
     *
     * @param sqidList
     * @return 实例对象
     */
    int deleteBySqidList(List<String> sqidList);
}

