package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyWdxx;
import cn.gtmap.hlw.core.model.query.GxYyWdxxQuery;
import com.baomidou.mybatisplus.core.metadata.IPage;

import java.util.List;

/**
 * 我的信箱(GxYyWdxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-07-06 15:54:16
 */
public interface GxYyWdxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyWdxx get(String id);

    /**
     * 新增数据
     *
     * @param gxYyWdxx 实例对象
     * @return 影响行数
     */
    void save(GxYyWdxx gxYyWdxx);

    /**
     * 批量更新或插入数据
     *
     * @param gxYyWdxxList 实例对象
     * @return 影响行数
     */
    void saveOrUpdateBatch(List<GxYyWdxx> gxYyWdxxList);

    /**
     * 修改数据
     *
     * @param gxYyWdxx 实例对象
     * @return 影响行数
     */
    void update(GxYyWdxx gxYyWdxx);

    /**
     * 获取数据
     *
     * @param jsr 接收人
     * @return 影响行数
     */
    List<GxYyWdxx> getByJsr(String jsr);

    /**
     * 分页查询
     * @param wdxxQuery
     * @return:IPage<GxYyWdxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    IPage<GxYyWdxx> page(GxYyWdxxQuery wdxxQuery);
    /**
     * 一键已读
     * @param userGuid
     * @param ywlx
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void yjyd(String userGuid, String ywlx);
    /**
     * 统计
     * @param userGuid
     * @param ywlx
     * @param sfyd
     * @return:Integer
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    Integer count(String userGuid, String ywlx, String sfyd);
    /**
     * 未读统计
     *
     * @param userGuid
     * @param userZjid
     * @return:List<GxYyWdxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyWdxx> wdtj(String userGuid, String userZjid);
    /**
     * 保存和更新
     * @param wdxx
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void saveOrUpdate(GxYyWdxx wdxx);
}

