package cn.gtmap.hlw.core.model;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * (GxYyFjxm)表实体类BO
 *
 * @author makejava
 * @since 2023-05-31 14:14:45
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyFjxm implements Serializable {
    private static final long serialVersionUID = -104920116575113537L;

    private String xmid;

    private String slbh;

    private String sqid;

    private String clfs;

    private String clys;

    private String wjlx;

    /**
     * 附件类型（gx_yy_zd_fj.dm或者页面生成各地区唯一附件类型代码）
     */
    private String fjlx;

    /**
     * 材料类型（字典表的FJLX）
     */
    private String cllx;

    /**
     * 附件类型名称
     */
    @ZdDzConfig(field = "fjlxmc", tableName = ZdDzConstant.ZD_DZ_CLMC, mcToMc = true)
    private String fjlxmc;

    /**
     * 是否轮播(0：否；1：是)
     */
    private String sflb;

    /**
     * 序号
     */
    private Integer xh;

    /**需推送的目标系统(zd_type表dm)英文逗号相隔*/
    private String pushsyslist;
    /**
     * 权利人类型
     */
    private String qlrlx;
    /**
     * 附件隐藏（申请类型）
     */
    private String fjyc;
}

