package cn.gtmap.hlw.core.dto.third.zjjg;

import cn.gtmap.hlw.core.annotation.ZdTypeConfig;
import cn.gtmap.hlw.core.constant.dict.ZdTypeConstant;
import lombok.Data;

import java.util.List;

/**
 * 资金监管办证凭证信息
 * @author <a href="mailto:wangchao@gtmap.cn">wangchao</a>
 * @version 2024/7/24 13:50
 * @description HtxxManageResultDTO
 */
@Data
public class ZjjgxxResultDTO {
    /**
     * 监管协议编号
     */
    private String jgxybh;

    /**
     * 合同编号
     */
    private String htbh;

    /**
     * 合同备案编号
     */
    private String htbabh;

    /**
     * 原产权证号
     */
    private String ycqzh;

    /**
     * 房屋坐落
     */
    private String fwzl;

    /**
     * 出卖人名称，多个英文逗号隔开
     */
    private String cmrmc;

    /**
     * 买受人名称，多个英文逗号隔开
     */
    private String msrmc;

    /**
     * 成交面积（平方米）
     */
    private String cjmj;

    /**
     * 成交金额（元）
     */
    private String cjje;

    /**
     * 监管金额（元）
     */
    private String jgje;

    /**
     * 经办人
     */
    private String jbr;

    /**
     * 交易明细
     */
    private List<ZjjgJymx> jymx;

    /**
     * 电子办证凭证UUID,可利用附件下载接口进行下载，撤销后为空
     */
    private String dzbzpz;

    /**
     * 贷款状态空：未生成办证凭证，或办证凭证已撤销
     * 01：监管有贷款
     * 02：监管无贷款
     * 03：带押过户有贷款
     * 04：带押过户无贷款
     * 05：免监管
     */
    private String zt;

    /**
     * 贷款状态名称
     */
    @ZdTypeConfig(field = "zt", tableName = ZdTypeConstant.ZD_TYPE_ZJJG_ZT, dmToMc = true)
    private String ztmc;

    /**
     * 生成时间
     */
    private String scsj;

    /**
     * 电子办证凭证下载地址
     */
    private String dzbzpzUrl;
}
