package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author： admin
 * @Data: 2020/12/4
 * @Description: 缴费状态
 */
@Getter
@AllArgsConstructor
public enum JfztEnum {

    /**未缴费 */
    JFZT_WJF("0","未缴费"),
    /** 已缴费*/
    JFZT_YJF("1","已缴费"),
    /** 已退款*/
    JFZT_YTK("2","已退款"),
    /** 退款中*/
    JFZT_TKZ("3","退款中"),
    /** 已取消*/
    JFZT_YQX("4","已取消"),
    /** 集中缴费*/
    JFZT_JZJF("5","集中缴费"),
    /** 无需缴费*/
    JFZT_WXJF("6","无需缴费"),
    /** 已挂账*/
    JFZT_YGZ("7","已挂账"),
    /** 已挂账*/
    JFZT_DSC("99","待生成");

    @Getter
    private String code;

    @Getter
    private String mc;

    public static String getMc(String code) {
        for (JfztEnum xq : JfztEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMc();
            }
        }
        return null;
    }
    public static String getCode(String mc) {
        for (JfztEnum xq : JfztEnum.values()) {
            if (xq.mc.equals(mc)) {
                return xq.getCode();
            }
        }
        return null;
    }

}
