/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.xml;

import cn.hutool.json.JSONObject;
import cn.hutool.json.XML;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import groovy.util.Node;
import groovy.util.XmlNodePrinter;
import groovy.util.XmlParser;
import groovy.xml.XmlUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static Node getXmlNodeByString(String xml) {
        try {
            xml = xml.replaceAll("&(?!amp;|lt;|gt;|quot;|apos;|#\\d+;|#x[0-9A-Fa-f]+;)", "&amp;");
            return new XmlParser().parseText(xml);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseFromXml(Class<T> clazz, String xml) {
        XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xStream.processAnnotations(clazz);
        Object t = xStream.fromXML(xml);
        return (T)t;
    }

    public static String processCharacterSet(String text) {
        if (StringUtils.isNotBlank((CharSequence)text)) {
            text = text.replace("&lt;", "<").replace("&gt;", ">").replace("&apos;", "'").replace("&amp;", "&").replace("&quot;", "\"");
        }
        return text;
    }

    public static String replacePageInXml(Node xml, String page) {
        if (xml != null && StringUtils.isNotEmpty((CharSequence)page)) {
            xml.setValue((Object)page);
        }
        return XmlUtil.serialize((Node)xml);
    }

    public static String processOtherDataSourcePageXml(Node page, Map dataMap, Map detailDataMap) {
        String datas = XmlUtils.parsePrintDatasXml(page, dataMap);
        String detail = XmlUtils.parseOtherDataSourcePrintDetailXml(page, detailDataMap);
        StringBuilder pageStr = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)datas)) {
            datas = "<datas></datas>";
        }
        pageStr.append(datas);
        pageStr.append(detail);
        return pageStr.toString();
    }

    static String parsePrintDatasXml(Node page, Map dataMap) {
        StringBuilder builder = new StringBuilder();
        boolean emptyMap = MapUtils.isEmpty((Map)dataMap);
        if (emptyMap) {
            dataMap = Maps.newHashMap();
        }
        ArrayList configKeys = Lists.newArrayList();
        page.children().forEach(data -> {
            Node datas = (Node)data;
            if (!StringUtils.equals((CharSequence)((CharSequence)datas.name()), (CharSequence)"detail")) {
                builder.append(XmlUtils.nodeToXmlString((Node)data));
                configKeys.addAll(Arrays.asList(StringUtils.split((String)((Node)data).text(), (char)'$')));
            }
        });
        Map finalDataMap = dataMap;
        configKeys.forEach(key -> finalDataMap.putIfAbsent(key, finalDataMap.containsKey(key) ? finalDataMap.get(key) : (finalDataMap.containsKey(StringUtils.lowerCase((String)key)) ? finalDataMap.get(StringUtils.lowerCase((String)key)) : "")));
        String xml = builder.toString();
        for (Map.Entry elem : finalDataMap.entrySet()) {
            xml = XmlUtils.replaceXml(String.valueOf(elem.getKey()), elem.getValue(), xml);
        }
        return xml;
    }

    public static String xml2json(String xml) {
        JSONObject jsonObject = XML.toJSONObject((String)xml.replace("<xml>", "").replace("</xml>", ""));
        return jsonObject.toString();
    }

    public static String toXml(Object obj) {
        XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xStream.processAnnotations(obj.getClass());
        return xStream.toXML(obj).replaceAll("\\_+", "_");
    }

    public static String nodeToXmlString(Node xml) {
        StringWriter stringWriter = new StringWriter();
        XmlNodePrinter nodePrinter = new XmlNodePrinter(new PrintWriter(stringWriter));
        nodePrinter.setPreserveWhitespace(true);
        nodePrinter.print(xml);
        return stringWriter.toString();
    }

    public static String replaceXml(String key, Object value, String xml) {
        xml = xml.replaceAll("\\>\\$" + StringUtils.upperCase((String)key) + "\\<", "\\>" + value + "\\<");
        xml = xml.replaceAll("\\>\\$" + StringUtils.lowerCase((String)key) + "\\<", "\\>" + value + "\\<");
        xml = xml.replaceAll("\\>\\$" + key + "\\<", "\\>" + value + "\\<");
        xml = xml.replaceAll("\\$\\{[" + StringUtils.upperCase((String)key) + "}]+\\}", String.valueOf(value));
        xml = xml.replaceAll("\\$\\{[" + StringUtils.lowerCase((String)key) + "}]+\\}", String.valueOf(value));
        xml = xml.replaceAll("\\$\\{[" + key + "}]+\\}", String.valueOf(value));
        return xml;
    }

    static String parseOtherDataSourcePrintDetailXml(Node page, Map dataMap) {
        StringBuilder pageXml = new StringBuilder();
        if (dataMap.isEmpty()) {
            return String.valueOf(pageXml);
        }
        page.children().forEach(data -> {
            Node detailData = (Node)data;
            if (StringUtils.equals((CharSequence)"detail", (CharSequence)String.valueOf(detailData.name()))) {
                detailData.name();
                String detailXml = XmlUtils.nodeToXmlString(detailData);
                String detailId = String.valueOf(detailData.attribute((Object)"ID"));
                StringBuilder dataBulider = new StringBuilder();
                StringBuilder rowBulider = new StringBuilder();
                ArrayList configKeys = Lists.newArrayList();
                detailData.children().forEach(it -> {
                    Node rowData = (Node)it;
                    rowBulider.append(XmlUtils.nodeToXmlString(rowData));
                    configKeys.addAll(Arrays.asList(StringUtils.split((String)rowData.text(), (char)'$')));
                    String id = String.valueOf(rowData.attribute((Object)"ID"));
                    if (StringUtils.isNotBlank((CharSequence)id)) {
                        id = StringUtils.replacePattern((String)id, (String)"\\$", (String)"");
                        id = StringUtils.replacePattern((String)id, (String)"\\{", (String)"");
                        id = StringUtils.replacePattern((String)id, (String)"\\}", (String)"");
                        configKeys.add(id);
                    }
                });
                List detailList = (List)dataMap.get(detailId);
                if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                    detailList.forEach(rowData -> {
                        configKeys.forEach(key -> rowData.putIfAbsent(key, rowData.containsKey(key) ? rowData.get(key) : (rowData.containsKey(StringUtils.lowerCase((String)key)) ? rowData.get(StringUtils.lowerCase((String)key)) : "")));
                        String xml = rowBulider.toString();
                        for (Map.Entry elem : rowData.entrySet()) {
                            xml = XmlUtils.replaceXml(String.valueOf(elem.getKey()), elem.getValue(), xml);
                        }
                        dataBulider.append(xml);
                    });
                }
                String pageDetail = StringUtils.replace((String)StringUtils.normalizeSpace((String)detailXml), (String)StringUtils.normalizeSpace((String)rowBulider.toString()), (String)StringUtils.normalizeSpace((String)dataBulider.toString()));
                pageXml.append(pageDetail);
            }
        });
        return pageXml.toString();
    }
}

