package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/7/18 19:16
 * @description 收费项目
 */
@Getter
@AllArgsConstructor
public enum SfxmEnum {

    /** 住宅类不动产登记费 */
    SFXM_ZZLBDCDJF("1041501","住宅类不动产登记费"),

    /** 非住宅类不动产登记费 */
    BDGL_FZZLBDCDJF("1041502","非住宅类不动产登记费"),

    /** 不动产权属证书工本费 */
    BDGL_BDCQSZSGBF("1041503","不动产权属证书工本费");

    @Getter
    private String code;

    @Getter
    private String msg;

    public static String getMsg(String code) {
        for (SfxmEnum xq : SfxmEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
