package cn.gtmap.hlw.core.dto.third.sso;

import lombok.Data;

/**
 * @Author jianglin
 * @Date 2024/8/29
 * @Description
 */
@Data
public class GtxdRequestParam {
    /**
     * @description 应用标识
     */
    private String appmark;

    /**
     * @description 时间戳，即当前时间
     * 格式为：年月日时分秒
     */
    private String time;

    /**
     * @description MD5(appmark + appword + time)
     * 即将应用标识、应用密钥、当前时间按顺序连接并进行md5加密
     */
    private String sign;

    /**
     * 业务名称
     */
    private String servicename;

    /**
     * 业务参数，json格式
     */
    private String params;

    /**
     * 票据
     */
    private String ticket;
    /**
     * 在政务大厅注册的zwdtuuid
     */
    private String uuid;

    private String token;
}
