package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyProcess;

import java.util.List;

/**
 * (GxYyProcess)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 15:07:05
 */
public interface GxYyProcessRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param processId 主键
     * @return 实例对象
     */
    GxYyProcess get(String processId);

    /**
     * 通过ID集合查询集合数据
     *
     * @param processIdList 主键集合
     * @return 实例对象集合
     */
    List<GxYyProcess> list(List<String> processIdList);

    /**
     * 新增数据
     *
     * @param gxYyProcess 实例对象
     * @return 影响行数
     */
    void save(GxYyProcess gxYyProcess);

    /**
     * 保存或更新
     *
     * @param gxYyProcess 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYyProcess gxYyProcess);


    /**
     * 更新数据
     *
     * @param gxYyProcess
     */
    void update(GxYyProcess gxYyProcess);

    /**
     * 删除数据
     *
     * @param processId 主键
     * @return 影响行数
     */
    void delete(String processId);

    /**
     * 通过sqlx, clientType查询单条数据
     *
     * @param sqlx       申请类型
     * @param clientType 客户端类型
     * @param type
     * @return 实例对象
     */
    List<GxYyProcess> get(String sqlx, String clientType, String type);

    /**
     * 通过sqlx, clientType查询单条数据
     *
     * @param sqlx       申请类型
     * @param clientType 客户端类型
     * @param type       资源类型
     * @param roleId     角色id
     * @return 实例对象
     */
    List<GxYyProcess> get(String sqlx, String clientType, String type, String roleId);

    /**
     * 批量更新或保存
     *
     * @param gxYyProcessList 客户端类型
     * @return 实例对象集合
     */
    void saveOrUpdateBatch(List<GxYyProcess> gxYyProcessList);

    /**
     * 通过sqlx查询数据
     *
     * @param sqlx 申请类型
     */
    List<GxYyProcess> getBySqlx(String sqlx);

    List<GxYyProcess> getBySqlxAndQLrlx(String sqlx, String qlrlx);
}

