package cn.gtmap.hlw.core.dto.workflow.export;

import cn.gtmap.hlw.core.dto.jdxx.JdxxAnDTO;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/12/26
 * @description
 */
@Data
public class SqlxJdxxDTO {
    private String id;

    /**
     * 节点类型（1:登记状态2：完税状态3：全流程状态）
     */
    private String jdlx;

    /**
     * 申请类型代码
     */
    private String sqlxdm;

    /**
     * 节点代码
     */
    private String jddm;

    /**
     * 节点名称
     */
    private String jdmc;

    /**
     * 节点名称顺序号
     */
    private Integer jdsxh;

    /**
     * 备注
     */
    private String bz;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 创建人员(gx_yy_user.USER_GUID)
     */
    private String createUser;

    /**
     * 修改人员(gx_yy_user.USER_GUID)
     */
    private String updateUser;

    /**
     * 节点级别
     */
    private String jdjb;

    /**
     * 父节点名称
     */
    private String fjddm;

    /**
     * 节点执行方式  0：被动 1：主动
     */
    private String jdzxfs;

    private List<SqlxJdxxDTO> zjdxxList;

    private List<SqlxJdxxLysjRelDTO> sqlxJdxxLysjRelList;

    private List<JdxxAnDTO> anList;
}
