package cn.gtmap.hlw.core.dto.sqxx.push.dj3.dyzy;


import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.dto.sqxx.push.dj2.sqxx.PushSqxxFsssxxDTO;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 2024/4/8 13:36
 * @description 登记3.0 转移抵押合并流程创建入参
 */
@Data
public class PushDj3DyZyBdcdyParamsBO {

    /**
     * 房屋面积
     */
    private String mj;

    /**
     * 是否抵押（0是，1否）
     */
    private String sfdy;

    /**
     * 是否查封（0是，1否）
     */
    private String sfcf;

    /**
     * 不动产单元号
     */
    private String bdcdyh;

    /**
     * 坐落
     */
    private String zl;

    /**
     * 房产证号
     */
    private String fczh;

    /**
     * 项目id(增加yxmid字段，为3.0业务数据主键)
     */
    private String yxmid;

    /**
     * 不动产单元编号
     */
    private String bdcdybh;

    /**
     * 土地证号
     */
    private String tdzh;

    /**
     * 土地项目id
     */
    private String tdxmid;

    /**
     * 房源编码
     */
    private String fybm;

    /**
     * 是否主房 1:是，0：否（3.0）
     */
    private String sfzf;

    /**
     * 行政区代码
     */
    private String xzqdm;

    /**
     * 行政区名称
     */
    private String xzqmc;

    /**
     * 乡镇街道代码
     */
    private String xzjddm;

    /**
     * 乡镇街道名称
     */
    private String xzjdmc;

    /**
     * 权籍关联代码
     */
    private String qjgldm;

    /**
     * 产权信息
     */
    @ZdDzConfig(field = "cqxx", tableName = "", isList = true)
    private List<PushDj3DyZyCqxxParamsBO> cqxx;

    /**
     * 抵押信息
     */
    @ZdDzConfig(field = "dyxx", tableName = "", isList = true)
    private List<PushDj3DyZyDyxxParamsBO> dyxx;

    /**
     * 查封信息
     */
    @ZdDzConfig(field = "cfxx", tableName = "", isList = true)
    private List<PushDj3DyZyCfxxParamsBO> cfxx;

    /**
     * 异议信息
     */
    @ZdDzConfig(field = "yyxx", tableName = "", isList = true)
    private List<PushDj3DyZyYyxxParamsBO> yyxx;

    /**
     * 附件信息
     */
    @ZdDzConfig(field = "fjxx", tableName = "", isList = true)
    private List<PushDj3DyZyFjxxParamsBO> fjxx;


    /**
     * 居住权信息
     */
    @ZdDzConfig(field = "jzqxx", tableName = "", isList = true)
    private List<PushDj3DyZyJzqxxParamsBO> jzqxx;
    /**
     * 林权信息
     */
    @ZdDzConfig(field = "lqxx", tableName = "", isList = true)
    private List<PushDj3ZhlcLqxxParamsBO> lqxx;

    /**
     * 土地承包经营权信息
     */
    @ZdDzConfig(field = "tdcbjyqxx", tableName = "", isList = true)
    private List<PushDj3ZhlcTdcbjyqxxParamsBO> tdcbjyqxx;
    /**
     * 土地经营权信息
     */
    @ZdDzConfig(field = "tdjyqxx", tableName = "", isList = true)
    private List<PushDj3ZhlcTdjyqxxParamsBO> tdjyqxx;


    /**
     * 地役权信息
     */
    @ZdDzConfig(field = "diyixx", tableName = "", isList = true)
    private List<PushDj3DyZyDiyixxParamsBO> diyixx;

    /**
     * 附属设施信息
     */
    private List<PushSqxxFsssxxDTO> fsssxx;
    /**
     * 外联证书信息
     */
    private  List<PushDj3DyZyWlzsxxBO> wlzsxx;
    /**
     * 备注
     */
    private String bz;
}
