package cn.gtmap.hlw.core.domain.sw.model.hs;

import cn.gtmap.hlw.core.dto.sw.hs.AhSwHsQueryDTO;
import cn.gtmap.hlw.core.dto.sw.hs.SwHsRwjsHouseDTO;
import cn.gtmap.hlw.core.dto.sw.hs.kunsan.KsSwHsQueryDTO;
import cn.gtmap.hlw.core.model.GxYySqxx;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/7/18 9:57
 * @description SwHsParamsModel
 */
@Data
public class SwHsParamsModel {
    /**
     * 领域事件代码
     */
    private String lysjdm;
    /**
     * 步骤id
     */
    private String processId;

    /**
     * 受理编号
     */
    private String slbh;
    /**
     * 区域代码
     */
    private String qydm;
    /**
     * 权利人证件号
     */
    private String qlrzjh;
    /**
     * 确认信息
     */
    private String qrxx;
    /**
     * 按钮id
     */
    private String anid;

    private GxYySqxx gxYySqxx;

    /**
     * 税务核税数据
     */
    private List<SwHsRwjsHouseDTO> rwjshouselist;

    /**
     * 税务核税数据(安徽)
     */
    private AhSwHsQueryDTO queryDTO;
    /**
     * 税务核税数据(昆山)
     */
    private KsSwHsQueryDTO ksSwHsQueryDTO;
    /**
     * 增量房存量房标志
     */
    private String zlfclfbz;
    /**
     * 是否组合
     */
    private Boolean sfzh = false;

    /**
     * 单独推送某个附件类型
     */
    private String fjlx;
    /**
     * 受理状态
     */
    private Integer slzt;

    /**
     * 是否终止领域动作
     */
    private Boolean sfzzlydz;
}
