package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxTdjy;

import java.util.List;

/**
 * 申请信息——土地经营(GxYySqxxTdjy)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:50
 */
public interface GxYySqxxTdjyRepository {

    /**
     * 通过受理编号查询单条数据
     *
     * @param slbh 受理编号
     * @return 实例对象
     */
    List<GxYySqxxTdjy> get(String slbh);

    /**
     * 通过申请ID查询数据集合
     *
     * @param sqid 申请ID
     * @return 实例对象
     */
    List<GxYySqxxTdjy> list(String sqid);

    /**
     * 通过申请ID查询数据
     *
     * @param sqid 申请ID
     * @return 实例对象
     */
    GxYySqxxTdjy getBySqid(String sqid);

    /**
     * 通过sqidList删除数据
     *
     * @param sqidList 实例对象
     * @return 影响行数
     */
    int deleteBySqidList(List<String> sqidList);

    /**
     * 批量保存或更新数据
     *
     * @param GxYySqxxTdjyList 实例对象
     * @return 影响行数
     */
    void saveOrUpdateBatch(List<GxYySqxxTdjy> GxYySqxxTdjyList);
}

