package cn.gtmap.hlw.core.annotation;


import java.lang.annotation.*;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2024/11/21
 * @description 接口访问频率注解，默认一分钟只能访问60次
 */
@Documented
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface RequestLimit {
    /**
     * 限制时间 单位：秒(默认值：一分钟）
     */
    long period() default 60;

    /**
     * 允许请求的次数(默认值：60次）
     */
    long count() default 60;
    /**
     * 方法名
     */
    String methodName() default "";
}
