package cn.gtmap.hlw.core.model;

import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/19 10:20
 * @description LysjModel
 */
@Data
public class JdxxLysjModel extends GxYyLysj {

    /**
     * 领域事件执行时间（before：之前执行，after：之后执行） gx_yy_process_lysj_rel.lysjzxsj 或 gx_yy_sqlx_jdxx_lysj_rel.lysjzxsj
     */
    private String lysjzxsj;
    /**
     * 领域事件执行顺序（事件执行的顺序，如果是同步执行，顺序号填一样）gx_yy_process_lysj_rel.lysjzxsx 或 gx_yy_sqlx_jdxx_lysj_rel.lysjzxsx
     */
    private String lysjzxsx;
    /**
     * 领域事件节点代码
     */
    private String jddm;
    /**
     * 按钮id（gx_yy_zd_an.anid）该字段如果为空表示页面初始化调用接口
     */
    private String anid;

    /**
     * 按钮名称（gx_yy_zd_an.anmc，可自定义）
     */
    private String anmc;

    /**
     * 按钮类型（gx_yy_zd_an.anlx，可自定义）
     */
    private String anlx;

    /**
     * 按钮顺序（1-99，1排在最前面，控制页面按钮排序）
     */
    private Integer ansx;
    /**
     * 按钮（前端）扩展配置（前端部分扩展配置）
     */
    private String ankzpz;

    /**
     * 方法类型(page:页面,method:方法）
     */
    private String fflx;

    /**
     * 地址
     */
    private String url;
    /**
     * 领域动作
     */
    private List<GxYyLydz> lydzList;
}
