package cn.gtmap.hlw.core.dto.exchange.push;

import cn.hutool.core.date.DatePattern;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2025/3/25
 * @description 房屋信息
 */
@Data
public class PushFwxxDTO {
    /**
     * 受理编号（与sqxx表关联）
     */
    private String slbh;

    /**
     * 房屋幢号
     */
    private String fwzh;

    /**
     * 产权证号
     */
    private String cqzh;

    /**
     * 房屋房号
     */
    private String fwfh;

    /**
     * 房屋总层数
     */
    private String fwzcs;

    /**
     * 房屋所在层
     */
    private String fwszc;

    /**实测建筑面积*/
    private String jzmj;

    /** 宗地面积*/
    private String zdmj;

    /**实测套内面积*/
    private String sctnmj;

    /**实测分摊面积*/
    private String scftmj;

    /**房屋用途*/
    private String fwyt;

    /**房屋用途名称*/
    private String fwytmc;

    /**房屋性质*/
    private String fwxz;

    /**房屋性质名称*/
    private String fwxzmc;

    /**预测建筑面积*/
    private String ycjzmj;

    private String jznf;

    /**房屋面积*/
    private String fwmj;

    /**房屋结构*/
    private String fwjg;

    /**房屋结构名称*/
    private String fwjgmc;

    /**房屋类型*/
    private String fwlx;

    /**申请id*/
    private String sqid;

    /**竣工时间*/
    private String jgsj;

    /**行政区划*/
    private String xzqhdm;

    /**所有权人*/
    private String syqr;

    /**房屋单元号*/
    private String fwdyh;

    /**阁楼面积*/
    private Double glmj;

    /**储藏室面积*/
    private Double ccsmj;

    /**自行车车库面积*/
    private Double zxcckmj;

    /**汽车车库面积*/
    private Double qcckmj;

    /**房屋朝向代码*/
    private String fwcxdm;

    /**规划用途代码*/
    private String ghytdm;

    /**房屋信息来源*/
    private String fwxxly;

    /**不动产项目名称*/
    private String bdcxmmc;

    /**权利性质代码*/
    private String qlxzdm;

    /**所在乡镇街道*/
    private String szxzjd;

    /**是否按揭(0：否，1：是)*/
    private String sfaj;

    /**房屋实际层（与房屋所在层区分）*/
    private String fwsjc;

    /**独用建筑面积 包括分摊面积，套内面积是实际使用面积*/
    private String dyjzmj;

    /**预测分摊面积*/
    private String ycftmj;

    /**预测套内面积*/
    private String yctnmj;

    /**是否有电梯0无1有*/
    private String isdt;

    /**房屋类别代码1高层2多层3别墅4平房5其他*/
    private String fwlbdm;

    /**区域代码*/
    private String qydm;

    /**是否多本证*/
    private String sfdbz;

    /**小区名称*/
    private String xqmc;

    /**权属转移方式(同登记原因)*/
    private String qszyfs;

    /**权属转移对象*/
    private String qszydx;

    /**权属转移用途*/
    private String qszyyt;

    /**是否临街（1：临街 2：不临街）*/
    private String sflj;

    /**是否顶层，1是0否*/
    private String sfdc;

    /**建成年份*/
    private String jcnf;

    /**业务小类（存放代码）*/
    private String ywxl;

    /**取得方式（存放代码）*/
    private String qdfs;

    /**其他权利状况*/
    private String qtqlzk;

    /**装修状况（存代码，字典项）*/
    private String zxzk;

    /**宗地用途代码*/
    private String zdytdm;

    /**宗地用途名称*/
    private String zdytmc;

    /**幢附着物代码*/
    private String zfzwdm;

    /**幢不动产单元号*/
    private String zbdcdyh;

    /**房屋编号，同houseid*/
    private String fwid;

    /**变动份额*/
    private Double bdfe;

    /**租赁情况（zd_type表对照）*/
    private String zlqk;

    /**承租人*/
    private String czr;

    /**抵押情况（zd_type表对照）*/
    private String dyqk;

    /**居住权情况（zd_type表对照）*/
    private String jzqqk;

    /**契税权属转移类别代码*/
    private String qsqszylbdm;

    /**契税权属转移对象代码*/
    private String qsqszydxdm;

    /**契税权属转移用途代码*/
    private String qsqszyytdm;

    /**道路名称*/
    private String dlmc;

    /**物业类型*/
    private String wylx;

    /**是否逻辑幢（1：是， 0：否）*/
    private String sfljz;

    /**房屋交付使用备案证书号*/
    private String jfbazsh;

    /**房屋交付备案证书发证日期*/
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date jfbafzrq;

    /**租赁期限（YYYY-MM-DD）*/
    private String zlqx;

    /**是否租赁（1是 0否）*/
    private String sfzl;
    /**
     * 挂牌价格
     */
    private Double gpjg;
    /**
     * 房屋户型
     */
    private String fwhx;
}
