package cn.gtmap.hlw.core.dao.ztfw;


import cn.gtmap.hlw.core.model.GxYyZtfwMenuRel;

import java.util.List;

/**
 * 专题服务与功能菜单关系表(GxYyZtfwMenuRel)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 14:34:59
 */
public interface GxYyZtfwMenuRelDao {

    /**
     * 查询
     *
     * @param ztfwid
     * @param functionMenuid
     * @return
     */
    List<GxYyZtfwMenuRel> getByZtfwidAndFunctionMenuid(List<String> ztfwid, String functionMenuid);

    /**
     * 保存
     *
     * @param gxYyZtfwMenuRelPO
     * @return
     */
    void saveOrUpdateZtfwMenuRelList(List<GxYyZtfwMenuRel> gxYyZtfwMenuRelPO);

    /**
     * 查询
     *
     * @param functionMenuId
     * @return
     */
    List<GxYyZtfwMenuRel> getByFunctionMenuId(String functionMenuId);

    /**
     * 查询
     *
     * @param functionMenuIdList
     * @return
     */
    List<GxYyZtfwMenuRel> getZtfwMenuRelList(List<String> functionMenuIdList);

    /**
     * 删除
     *
     * @param functionMenuId
     * @return
     */
    void deleteByFunctionMenuId(String functionMenuId);

    /**
     * 根据zid得到FUNCTION_MENU_ID集合
     *
     * @param ztfwIds 实例对象集合
     * @return Map<GxYyZtfw, List < String>>
     */
    List<GxYyZtfwMenuRel> getZtfwMenuRelByZtfwIds(List<String> ztfwIds);

    /**
     * 批量保存
     *
     * @param ztfwMenuRelList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void insertBatchSomeColumn(List<GxYyZtfwMenuRel> ztfwMenuRelList);

    /**
     * 根据菜单id集合删除
     *
     * @param functionMenuIdList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteByFunctionMenuIdList(List<String> functionMenuIdList);
    /**
     * 批量保存或更新
     *
     * @param ztfwMenuRelPoList
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    void saveOrUpdateBatch(List<GxYyZtfwMenuRel> ztfwMenuRelPoList);
}

