package cn.gtmap.hlw.core.dao.jkgl;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.jkgl.JkglPageParamsDTO;
import cn.gtmap.hlw.core.model.GxYyJkgl;

import java.util.List;

/**
 * 接口管理表(GxYyJkgl)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-06 14:48:08
 */
public interface GxYyJkglDao {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyJkgl get(String id);


    /**
     * 根据行政区域代码和接口关键字去查询接口管理表
     * @param xzqydm
     * @param jkgjz
     * @return
     */
    GxYyJkgl query(String xzqydm, String jkgjz);

    /**
     * 接口管理分页查询
     * @param paramsDTO
     * @return
     */

    PageInfo<GxYyJkgl> queryPage(JkglPageParamsDTO paramsDTO);

    /**
     *接口管理删除数据
     * @param id 主键
     * @return 删除的数量
     */
    int delete(String id);
    /**
     *接口管理删除数据
     * @param idList 主键
     * @return 删除的数量
     */
    int deleteBatchIds(List<String> idList);

    /**
     * 获取接口管理表的全部数据
     * @return GxYyJkglPO集合
     */
    List<GxYyJkgl> getAll();
    /**
     * 获取接口管理表的数据
     * @param xzqydm 行政区域代码
     * @param xtdm 系统代码
     * @return GxYyJkglPO集合
     */
    List<GxYyJkgl> getByqydmAndXtdm(String xzqydm,String xtdm);
    /**
     * 获取接口管理表的数据
     * @param xzqydm 行政区域代码
     * @param xtdm 系统代码
     * @param jkgjz jkgjz
     * @return GxYyJkglPO集合
     */
    List<GxYyJkgl> getByqydmAndXtdmAndJkgjz(String xzqydm,String xtdm,String jkgjz);

    /**
     * 保存更新
     * @param gxYyJkgl
     * @return
     */
    String saveOrUpdatejKGL(GxYyJkgl gxYyJkgl);

    /**
     * 新增数据
     *
     * @param gxYyJkgl 实例对象
     * @return 影响行数
     */
    String saveJkgl(GxYyJkgl gxYyJkgl);

    /**
     * 修改数据
     *
     * @param gxYyJkgl 实例对象
     * @return 影响行数
     */
    String updateJkgl(GxYyJkgl gxYyJkgl);

    /**
     * 根据jkgjz集合查询
     * @param jkgjzList
     * @return:List<GxYyJkglPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYyJkgl> listByJkgjzList(List<String> jkgjzList);
    /**
     * 根据接口关键字查询
     * @param jkgjz
     * @return:List<GxYyJkglPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    GxYyJkgl getByJkgjz(String jkgjz);
    /**
     * 批量插入
     * @param jkglPoList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void insertBatch(List<GxYyJkgl> jkglPoList);
}

