package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.sqxx.lyzx.LyzxQueryPageParamDTO;
import cn.gtmap.hlw.core.model.GxYySmrx;

import java.util.Date;

/**
 * 市民热线表(GxYySmrx)表数据库访问层
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2024-05-30 15:25:44
 */
public interface GxYySmrxRepository {

    /**
     * 分页查询
     *
     * @param lyzxQueryPageParamDTO
     * @return 分页对象
     */
    PageInfo<GxYySmrx> queryPage(LyzxQueryPageParamDTO lyzxQueryPageParamDTO);

    /**
     * 通过主键查询
     *
     * @param sqid 诉求id
     * @return GxYySmrx
     */
    GxYySmrx getBySqid(String sqid);

    /**
     * 保存或修改
     *
     * @param gxYySmrx
     */
    void saveOrUpdate(GxYySmrx gxYySmrx);

    /**
     * 通过主键删除数据
     *
     * @param sqid 诉求id 主键
     */
    void deleteBySqid(String sqid);

    /**
     * 根据创建时间获取我的咨询数量
     *
     * @param kssj kssj
     * @param jssj jssj
     * @param userId userId
     */
    Integer getZxxxNumByCreateDate(Date kssj, Date jssj, String userId);
}

