package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyDjzxOrgRel;

import java.util.List;

/**
 * 登记中心与部门对照(GxYyDjzxOrgRel)表数据库访问层
 *
 * @author makejava
 * @since 2023-09-06 19:20:26
 */
public interface GxYyDjzxOrgRelRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyDjzxOrgRel get(String id);

    /**
     * 新增数据
     *
     * @param gxYyDjzxOrgRel 实例对象
     * @return 影响行数
     */
    void save(GxYyDjzxOrgRel gxYyDjzxOrgRel);

    /**
     * 修改数据
     *
     * @param gxYyDjzxOrgRel 实例对象
     * @return 影响行数
     */
    void update(GxYyDjzxOrgRel gxYyDjzxOrgRel);

    /**
     * 根据登记部门获取登记中心
     *
     * @param orgId
     * @return
     */
    List<GxYyDjzxOrgRel> getByOrgId(String orgId);

    /**
     * 获取数据
     *
     * @return 影响行数
     */
    List<GxYyDjzxOrgRel> getAll();

    /**
     * 删除数据
     *
     * @param id
     * @return 影响行数
     */
    int delete(String id);
}

