package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYcXqxx;

import java.util.List;

/**
 * 一窗小区信息(GxYcXqxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-10-30 14:25:57
 */
public interface GxYcXqxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param xqid 主键
     * @return 实例对象
     */
    GxYcXqxx get(Integer xqid);

    /**
     * 新增数据
     *
     * @param gxYcXqxx 实例对象
     * @return 影响行数
     */
    void save(GxYcXqxx gxYcXqxx);

    /**
     * 修改数据
     *
     * @param gxYcXqxx 实例对象
     * @return 影响行数
     */
    void update(GxYcXqxx gxYcXqxx);

    /**
     * 查询所有数据
     *
     * @param xqmc 小区名称
     * @return 实例对象
     */
    List<GxYcXqxx> getByXqmc(String xqmc);


}

