package cn.gtmap.hlw.core.dto.sqxx.save;

import cn.hutool.core.date.DatePattern;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/7 22:17
 * @description 查封信息
 */
@Data
public class CfxxDTO implements Serializable {
    private Integer cfxxid;

    /**受理编号 （与sqxx表关联）*/
    private String slbh;

    /**查封文号*/
    private String cfwh;

    /**查封机关*/
    private String cfjg;

    /**查封申请人*/
    private String cfsqr;

    /**查封开始日期*/
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date cfksrq;

    /**查封结束日期*/
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date cfjsrq;

    /**解封机关*/
    private String jfjg;

    /**解封文号*/
    private String jfwh;

    /**查封文件*/
    private String cfwj;

    /**解封文件*/
    private String jfwj;

    /**解封日期*/
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date jfrq;

    /**续封开始日期*/
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date xfksrq;

    /**续封结束日期*/
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date xfjsrq;

    /**查封范围*/
    private String cffw;

    /**sqid,与sqxx表中sqid关联*/
    private String sqid;

    /** 附记*/
    private String fj;

    /**s法院送达人联系电话*/
    private String fysdrlxdh;

    /**续封申请人*/
    private String xfsqr;

    /**续封文号*/
    private String xfwh;

    /**续封文件*/
    private String xfwj;

    /**续封机关*/
    private String xfjg;

    /**续封范围*/
    private String xffw;

    private String fysdr;

    private String jfsdr;

    private String jfsdrlxdh;

    /**法院查封送达人*/
    private String fycfsdr;

    /**法院解封送达人*/
    private String fyjfsdr;

    /**法院解封送达人电话*/
    private String fyjfsdrlxdh;

    private String cflx;
    /**
     * 查封顺序
     */
    private Integer cfsx;
    /**
     * 来文日期
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date lwrq;

    /**
     * 查封登记时间
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date djsj;
    /**
     * 解封申请人
     */
    private String jfsqr;
    private String qszt;
    private String cqzh;
}
