package cn.gtmap.hlw.core.dao.form;

import cn.gtmap.hlw.core.base.BasePage;
import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.model.GxYyForm;

import java.util.List;

/**
 * 表单表(GxYyForm)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 14:19:33
 */
public interface GxYyFormDao {

    /**
     * 通过ID查询单条数据
     *
     * @param formid 主键
     * @return 实例对象
     */
    GxYyForm get(String formid);

    /**
     * 新增数据
     *
     * @param gxYyForm 实例对象
     * @return 影响行数
     */
    void saveForm(GxYyForm gxYyForm);

    /**
     * 新增数据或更新数据
     *
     * @param gxYyForm 实例对象
     * @return 影响行数
     */
    void saveOrUpdateForm(GxYyForm gxYyForm);

    /**
     * 修改数据
     *
     * @param gxYyForm 实例对象
     * @return 影响行数
     */
    void update(GxYyForm gxYyForm);

    /**
     * 批量保存
     *
     * @param  gxYyFormList 实例对象集合
     * @return 影响行数
     */
    void saveBatch(List<GxYyForm> gxYyFormList);

    /**
     * 批量更新
     *
     * @param  gxYyFormList 实例对象集合
     * @return 影响行数
     */
    void updateBatch(List<GxYyForm> gxYyFormList);

    /**
     * 批量更新或保存
     *
     * @param  gxYyFormList 实例对象集合
     * @return 影响行数
     */
    void saveOrUpdateBatch(List<GxYyForm> gxYyFormList);

    /**
     * 修改数据
     *
     * @param formIds id集合
     * @return 影响行数
     */
    List<GxYyForm> getForms(List<String> formIds);

    /**
     * 根据formid查询信息
     *
     * @param formid
     * @return
     */
    List<GxYyForm> getByFormid(String formid);

    /**
     * 分页查询
     *
     * @param gxYyForm
     * @param basePage 分页参数
     * @return PageInfo<GxYyForm>
     */
    PageInfo<GxYyForm> queryPage(GxYyForm gxYyForm, BasePage basePage);

    /**
     * 根据uuid删除
     * @param uuid
     */
    void delete(String uuid);

    /**
     * 根据formid查询
     * @param formIdList
     * @return:List<GxYyForm>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYyForm> listByFormIds(List<String> formIdList);
    /**
     * 批量保存
     * @param formList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void insertBatchSomeColumn(List<GxYyForm> formList);

    /**
     * 根据formid集合删除
     * @param formIdList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void deleteByFormIdList(List<String> formIdList);
    /**
     * 根据formid查询
     * @param formid
     * @return:List<GxYyForm>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYyForm> listByFormId(String formid);
}

