package cn.gtmap.hlw.core.util.file;

import cn.gtmap.hlw.core.constant.Constants;
import cn.gtmap.hlw.core.util.date.DateUtils;
import cn.gtmap.hlw.core.util.thread.ThreadPoolMdcExecutor;
import cn.hutool.core.io.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2023/7/13
 * @description 文件操作工具类
 */
public class LogFileUtils {

    private static final Logger logger = LoggerFactory.getLogger(LogFileUtils.class);

    // 异步写入文件的方法
    public static void writeToFileAsync(String content, String slbh) {
        // 确保目录存在，避免不必要的目录创建
        String uploadFilePath = "/pushDjJson/";
        // 使用 FileUtil.mkdir 如果目录不存在才创建
        File dir = new File(uploadFilePath);
        if (!dir.exists()) {
            FileUtil.mkdir(uploadFilePath);
        }

        String filePath = uploadFilePath + DateUtils.dateToStr(new Date(), DateUtils.PURE_DATETIME_PATTERN) + Constants.DASH + slbh + ".txt";

        // 定义分块大小（可以根据实际需要调整）
        final int CHUNK_SIZE = 1024 * 1024; // 1MB为一块大小

        ThreadPoolMdcExecutor.execute(() -> {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath))) {
                int contentLength = content.length();
                int offset = 0;

                // 分块写入
                while (offset < contentLength) {
                    int end = Math.min(offset + CHUNK_SIZE, contentLength);
                    writer.write(content, offset, end - offset);
                    offset = end;
                }

                logger.info("数据已成功写入文件: {}", filePath);
            } catch (IOException e) {
                logger.error("写入文件时出错，文件路径: {}，错误信息: {}", filePath, e.getMessage(), e); // 输出详细异常信息
            }
        });
    }
}
