package cn.gtmap.hlw.core.util.encryption;

import cn.gtmap.hlw.core.base.ApiEncryptBody;
import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import cn.gtmap.hlw.core.util.encryption.sm4.Sm4Util;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;

import java.text.DecimalFormat;

/**
 * @Author jianglin
 * @Date 2024/6/27
 * @Description 接口出入参-加解密-工具类
 */
@Slf4j
public class ApiSecurityUtils {

    /**
     * @param sm4KeyBySm2 经过Sm2加密的sm4key
     * @param decryptStr  经过sm4加密的数据
     * @return 解密后的数据
     */
    public static String decrypt(String sm4KeyBySm2, String decryptStr) {
        String sm4Key = Sm2lib.decode(sm4KeyBySm2);
        return Sm4Util.decryptEcb(sm4Key, decryptStr);
    }

    /**
     * @param encryptStr     要加密的数据
     * @param frontPublicKey 前端公钥
     * @return 加密后的数据
     */
    public static ApiEncryptBody encrypt(String encryptStr, String frontPublicKey) throws Exception {
        //生成一个随机的sm4加密key
        String sm4Key = Sm4Util.generateKey();
        //加密
        String data = Sm4Util.encryptEcb(sm4Key, encryptStr);
        ApiEncryptBody apiEncryptRes = new ApiEncryptBody();
        //用前端公钥(用前端的公钥)，sm2加密sm4Key
        apiEncryptRes.setParamid(Sm2lib.encode(sm4Key, frontPublicKey));
        apiEncryptRes.setData(data);
        apiEncryptRes.setFrontKey(frontPublicKey);
        return apiEncryptRes;
    }

    //加解密测试
    public static void main(String[] args) throws Exception {
        String pubKey = "c2f1831616943efe504bde6b45d59eea953f04d31ecebd4c59dffd6733c7a066c7a9c14cb2c54564187891f72753fea7f56d07b19d52e9076263564def41b8e7";

        //前端入参 解密
        String dataEncrypt = "4626c1efbb41555fa1173c388cbbf9902bd1f477f51d7c9fdd167a18dee27729fa22496482a6d6f111ab2ee7007e3403";
        String paramid = "04590e294983e22c8d365b3d9c74cac12d4edb60842093137c63b5f6c08b24b884c833c2d7118abda4e7e7baf8bcfc8ad3c6141c7a974712ce2582fcc6d7ef93a480e1c6e61084142f0b079302a3c531b737dc690fb75d32a3daae24e333ff5e01b426a5f39090a4aee2c884eb4f978be829f8ec7dda24859272e45b75edf6752917b5241bc433a8a9854f726a";
        String qdData = ApiSecurityUtils.decrypt(paramid, dataEncrypt);
        System.out.println(qdData);


        /*//生成前端加密密文
        //生成一个随机的sm4加密key
        String sm4Key = "B13356B451572BFC3478AC20F0E3E163";
        //前端入参
        String encryptStr = "{\"sqid\":\"\",\"qlrmc\":\"周建飞\",\"qlrzjh\":\"340823199406243115\"}";
        //加密
        String data = Sm4Util.encryptEcb(sm4Key, encryptStr);
        String paramid2 = Sm2lib.encode(sm4Key);

        ApiEncryptBody body = new ApiEncryptBody();
        body.setData(data);
        body.setParamid(paramid2);
        body.setFrontKey(pubKey);

        System.out.println(JSON.toJSONString(body));*/
    }

}
