package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxWlzsxx;

import java.util.List;

/**
 * 申请信息外联证书信息(GxYySqxxWlzsxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:50
 */
public interface GxYySqxxWlzsxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param wlzsid 主键
     * @return 实例对象
     */
    GxYySqxxWlzsxx get(String wlzsid);


    /**
     * 新增数据
     *
     * @param gxYySqxxWlzsxx 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxWlzsxx gxYySqxxWlzsxx);

    /**
     * 修改数据
     *
     * @param gxYySqxxWlzsxx 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxWlzsxx gxYySqxxWlzsxx);

    /**
     * 批量更新
     * @param wlzsxxList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void saveOrUpdateBatch(List<GxYySqxxWlzsxx> wlzsxxList);

    /**
     * 根据slbh查询
     * @param slbh
     * @return:List<GxYySqxxWlzsxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYySqxxWlzsxx> list(String slbh);

    /**
     * 根据sqidList查询
     * @param sqidList
     * @return:List<GxYySqxxWlzsxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYySqxxWlzsxx> list(List<String> sqidList);
    /**
     * 根据sqid查询
     * @param sqid
     * @return:GxYySqxxWlzsxx
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    GxYySqxxWlzsxx getBySqid(String sqid);
    /**
     * 批量插入
     * @param wlzsxxList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void insertBatch(List<GxYySqxxWlzsxx> wlzsxxList);
}

