package cn.gtmap.hlw.core.repository;


import cn.gtmap.hlw.core.model.WctJyDdxx;

import java.util.List;
import java.util.Map;

/**
 * (WctJyDdxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
public interface WctJyDdxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    WctJyDdxx get(String id);

    /**
     * 新增数据
     *
     * @param wctJyDdxx 实例对象
     * @return 影响行数
     */
    void save(WctJyDdxx wctJyDdxx);

    /**
     * 修改数据
     *
     * @param wctJyDdxx 实例对象
     * @return 影响行数
     */
    void update(WctJyDdxx wctJyDdxx);

    /**
     * 批量新增数据
     *
     * @param ddxxList 实例对象
     * @return 影响行数
     */
    void saveBatch(List<WctJyDdxx> ddxxList);

    /**
     * 查询（根据 columnMap 条件）
     *
     * @param map 实例对象
     * @return 影响行数
     */
    List<WctJyDdxx> getListByMap(Map<String, Object> map);

    /**
     * 根据订单编号删除
     *
     * @param ddbh 实例对象
     * @return 影响行数
     */
    void deleteByDdbh(String ddbh);

    /**
     * 根据受理编号查询订单信息
     * @param ywxtslbh
     * @return:List<WctJyDdxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<WctJyDdxx> listBySlbh(String ywxtslbh);
    /**
     * 根据订单编号查询
     * @param ddbh
     * @return:cn.gtmap.hlw.domain.wct.model.WctJyDdxx
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    WctJyDdxx getByDdbh(String ddbh);
}

