package cn.gtmap.hlw.core.dto.third.cqxx.daxx;

import cn.gtmap.hlw.core.base.UserInfo;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/12/12 9:53
 * @description GetDaxxQueryParamsDTO
 */
@Data
public class GetDaxxQueryParamsDTO {
    /**
     * 区域代码
     */
    private String qydm;
    /**
     * 权利人名称
     */
    private String qlrmc;
    /**
     * 权利人证件号
     */
    private String qlrzjh;
    /**
     * 项目id
     */
    private String xmid;
    /**
     * 证书id
     */
    private String zsid;
    /**
     * 权属状态代码，根据前端传入的状态查询现势或历史，传入"1,2"即查询全部
     */
    private String qsztdm;
    /**
     * 批量查询
     */
    List<GetDaxxQueryParamsDTO> list;
    /**
     * 当前登录用户信息（存在异步执行打印的情况，session取值当前登录人会存在取不到值的问题）
     */
    private UserInfo userInfo;
    /**
     * 是否走redis缓存
     */
    private Boolean useRedis = true;
}
