package cn.gtmap.hlw.core.dto.pcgl;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2024/9/19
 * @description 破产管理申请DTO
 */
@Data
public class PcglSqxxResultDTO {

    /**ID主键 */
    private String id;

    /**区域代码 */
    private String qydm;

    /**受理编号 */
    private String slbh;

    /**申请类型 */
    private String sqlx;

    /**申请人用户GUID */
    private String applyUserGuid;

    /**申请人*/
    private String realName;

    /**单位名称 */
    private String orgName;

    /**证件号码（营业执照） */
    private String zjh;

    /**是否同意（0：不同意，1：同意，2：待审核） */
    private String isAgree;

    /**审批人用户GUID */
    private String approvalUserGuid;

    /**创建时间*/
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**修改时间*/
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /**审核意见*/
    private String shyj;
}
