package cn.gtmap.hlw.core.dto.dypz;


import cn.gtmap.hlw.core.dto.workflow.export.LcdyPzDTO;
import cn.gtmap.hlw.core.model.GxYyDysjPz;
import cn.gtmap.hlw.core.model.GxYyDysjZbPz;
import cn.gtmap.hlw.core.util.encryption.sm4.Sm4Util;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2024/5/30
 * @description 打印配置接口交互类
 */
@Data
public class DysjPzDTO extends GxYyDysjPz {
    /**
     * 顺序号
     */
    private String sxh;

    List<GxYyDysjZbPz> gxYyDysjZbPzList;

    /**
     * 打印参数
     */
    List<Map<String, Object>> dycsMapList;

    /**
     * 云签打印配置
     */
    List<LcdyPzDTO> gxYyLcdyList;
    private String sm4Key = "B13356B451572BFC3478AC20F0E3E163";


    /**
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 解密执行SQL
     */
    public void decodeSm4(){
        if (StringUtils.isNotBlank(super.getDysjy())) {
            super.setDysjy(Sm4Util.decryptEcb(sm4Key, super.getDysjy()));
            this.getGxYyDysjZbPzList().stream().forEach(po -> {
                if (StringUtils.isNotBlank(po.getDyzbsjy())) {
                    po.setDyzbsjy(Sm4Util.decryptEcb(sm4Key, po.getDyzbsjy()));
                }
            });
        }
    }

    /**
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 加密执行SQL
     */
    public void encodeSm4() {
        if (StringUtils.isNotBlank(super.getDysjy())) {
            super.setDysjy(Sm4Util.encryptEcb(sm4Key, super.getDysjy()));
            this.getGxYyDysjZbPzList().stream().forEach(po -> {
                if (StringUtils.isNotBlank(po.getDyzbsjy())) {
                    po.setDyzbsjy(Sm4Util.encryptEcb(sm4Key, po.getDyzbsjy()));
                }
            });
        }
    }
}
