/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.node;

import cn.gtmap.hlw.core.node.INode;
import java.util.ArrayList;
import java.util.List;

public class ForestNodeManager<T extends INode<T>> {
    private final List<T> list;
    private final List<String> parentIds = new ArrayList<String>();

    public ForestNodeManager(List<T> items) {
        this.list = items;
    }

    public void addParentId(String parentId) {
        this.parentIds.add(parentId);
    }

    public List<T> getRoot() {
        ArrayList<INode> roots = new ArrayList<INode>();
        for (INode forestNode : this.list) {
            if (!"0".equals(forestNode.getParentId()) && !this.parentIds.contains(forestNode.getId())) continue;
            roots.add(forestNode);
        }
        return roots;
    }

    public INode getTreeNodeAt(String id) {
        for (INode forestNode : this.list) {
            if (!forestNode.getId().equals(id)) continue;
            return forestNode;
        }
        return null;
    }
}

