package cn.gtmap.hlw.core.enums.qlr;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 代理人类型 0：企业法定代表人 1：普通代理人(默认1 )
 *
 * @author admin
 * @Date 2023-06-25
 * @Version V1.0
 */
@Getter
@AllArgsConstructor
public enum DlrEnum {
    /**
     * 企业法定代表人
     */
    DLR_QY(0, "企业法定代表人"),
    /**
     * 普通代理人
     */
    DLR_GR(1, "普通代理人");


    private Integer code;

    private String msg;

    public static String getMsg(Integer code) {
        for (DlrEnum xq : DlrEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}

