package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyYjd;

import java.util.List;

/**
 * (GxYyYjd)表数据库访问层
 *
 * @author makejava
 * @since 2023-11-17 10:35:58
 */
public interface GxYyYjdRepository {

    /**
     * 新增数据
     *
     * @param gxYyYjd 实例对象
     * @return 影响行数
     */
    void save(GxYyYjd gxYyYjd);

    /**
     * 修改数据
     *
     * @param gxYyYjd 实例对象
     * @return 影响行数
     */
    void update(GxYyYjd gxYyYjd);
    /**
     * 保存数据
     * @param yjdList
     * @return 影响行数
     */
    void saveBatch(List<GxYyYjd> yjdList);
    /**
     * 根据slbh查询
     * @param slbhList 受理编号集合
     * @return List<GxYyYjd>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYyYjd> listBySlbhList(List<String> slbhList);
    /**
     * 根据yjdbh查询
     * @param yjdbh 移交单编号
     * @return List<GxYyYjd>
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<GxYyYjd> list(String yjdbh);
    /**
     * 根据yjdbh删除数据
     * @param yjdbh 移交单编号
     * @return List<GxYyYjd>
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    int deleteByYjdh(String yjdbh);
}

