package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 节点信息(GxYySqlxJdxx)表实体类BO
 *
 * @author makejava
 * @since 2023-06-01 14:50:54
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYySqlxJdxx implements Serializable {
    private static final long serialVersionUID = 7322860794553741479L;
    /**节点id*/
    private String id;

    /**节点类型（1:登记状态2：完税状态3：全流程状态）*/
    private String jdlx;

    /**申请类型代码*/
    private String sqlxdm;

    /**节点代码*/
    private String jddm;

    /**节点名称*/
    private String jdmc;

    /**节点名称顺序号*/
    private Integer jdsxh;

    /**备注*/
    private String bz;

    /**创建时间*/
    private Date createTime;

    /**修改时间*/
    private Date updateTime;

    /**创建人员(gx_yy_user.USER_GUID)*/
    private String createUser;

    /**修改人员(gx_yy_user.USER_GUID)*/
    private String updateUser;

    /**节点级别*/
    private String jdjb;

    /**父节点名称*/
    private String fjddm;

    /**方法类型(page:页面,method:方法）*/
    private String fflx;

    /**地址*/
    private String url;
    /**
     * 节点执行方式  0：被动 1：主动
     */
    private String jdzxfs;


}

