package cn.gtmap.hlw.core.dto.sqxx.push.dj3;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import cn.gtmap.hlw.core.constant.dict.ZdTypeConstant;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/9/10 19:47
 * @description PushDj3SqxxGxrxxParamsBO
 */
@Data
public class PushDj3SqxxGxrxxParamsBO {
    /**
     * 关系人姓名
     */
    private String gxrmc;
    /**
     * 关系人身份证件种类
     */
    private String gxrsfzjzl;
    /**
     * 关系人证件号
     */
    private String gxrzjh;
    /**
     * 关系人联系电话
     */
    private String gxrlxdh;
    /**
     * 关系人通讯地址
     */
    private String gxrtxdz;
    /**
     * 关系人类型
     */
    @ZdDzConfig(field = "gxrlx", tableName = ZdDzConstant.ZD_DZ_QLRLX, dmToDm = true, isSetBlank = true)
    private String gxrlx;
    /**
     * 权利比例
     */
    private String qlbl;
    /**
     * 房屋套次
     */
    private String fwtc;
    /**
     * 申报房屋套次
     */
    private String sbfwtc;
    /**
     * 是否本地户籍
     */
    private String sfbdhj;
    /**
     * 共有方式
     */
    private String gyfs;
    /**
     * 婚姻状况
     */
    private String hyzt;
    /**
     * 税号
     */
    private String sh;
    /**
     * 关系人代理人
     */
    private String gxrdlr;
    /**
     * 关系人代理人证件种类
     */
    private String gxrdlrzjzl;
    /**
     * 关系人代理人证件号
     */
    private String gxrdlrzjh;
    /**
     * 税款减免 0 否 1 是 放代码
     */
    private String skjm;
    /**
     * HYK 新增契税满两年 0 未满两年 1 满两年 放代码
     */
    private String qsmln;
    /**
     * 家庭成员信息
     */
    private List<PushDj3SqxxGxrxxJtcyParamsBO> jtcy;
    /**
     * 是否本人，当前登陆用户，0是，1否
     */
    private String sfbr;
    /**
     * 证件类型判断，如果是6：组织机构代码，或者7：营业执照 ，那么权利人种类代码	qlrzldm：2   qlrzlmc：企业；否则为qlrzldm：1 qlrzlmc：个人，如果为空默认为1个人
     * 关系人种类代码	gxrzldm	字符串				1个人、2企业，放代码
     * 关系人种类名称	gxrzlmc	字符串				个人、企业，放名称
     */
    private String gxrzldm;
    private String gxrzlmc;
    /**
     * 18	共有方式	gyfs	字符串				表5.12 ycsl_zd_gyfs 共有方式字典表 放代码
     * 19	共有方式名称	gyfsmc	字符串				表5.12 ycsl_zd_gyfs 共有方式字典表 放名称
     */
    private String gyfsmc;
    /**
     * 20	关系人代理人联系电话	gxrdlrdh	字符串
     */
    private String gxrdlrdh;

    /**
     * 新增字段，用于保存qlr表数据sfws  是否完税（0 否 1 是 ）
     */
    private String sfws;
    /**
     * 是否直系亲属        sfzxqs        字符串  这个传 0 否 1 是 放代码
     */
    private String sfzxqs;
    /**
     * 关系人身份证件种类名称
     */
    private String gxrsfzjzlmc;
    /**
     * 共有比例
     */
    private String gybl;

    /**
     * 是否缴税（0 是 1 否 ）
     */
    private String sfjs;

    /**
     * 产权证号
     */
    private String cqzh;
    /**
     * @author <a href="mailto:huangyongkai@gtmap.cn">huangyongkai</a>
     * @description `DYSX` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '组合贷时，标识公积金、银行等抵押顺序',
     */
    private String dysx;
    /**
     * 国籍代码 名称
     */
    private String gjdm;
    private String gjmc;


    private List<PushDj3SqxxGxrxxDlrParamsBO> gxrdlrList;


    /**
     * 现有住房坐落
     */
    private String xyzfzl;

    /**
     * 持证方式代码
     */
    @ZdDzConfig(field = "czfsdm", tableName = ZdTypeConstant.ZD_TYPE_CZFS, dmToDm = true, isSetBlank = true)
    private String czfsdm;

    /**
     * 持证方式名称
     */
    @ZdDzConfig(field = "czfsmc", tableName = ZdTypeConstant.ZD_TYPE_CZFS, dmToMc = true, isSetBlank = true)
    private String czfsmc;

    /**
     * 顺序号
     */
    private String sxh;
}
