package cn.gtmap.hlw.core.dao.lysj;

import cn.gtmap.hlw.core.model.GxYySqlxJdxxLysjRel;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/12/26
 * @description
 */
public interface GxYySqlxJdxxLysjRelDao {
    /**
     * 根据sqlx查询
     * @param sqlx
     * @return:List<GxYySqlxJdxxLysjRelPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYySqlxJdxxLysjRel> listBySqlx(String sqlx);

    /**
     * 根据sqlx和jddm查询
     * @param sqlx
     * @param jddmList
     * @return:List<GxYySqlxJdxxLysjRelPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYySqlxJdxxLysjRel> listBySqlxAndJddmList(String sqlx, List<String> jddmList);
    /**
     * 批量保存
     * @param sqlxJdxxLysjRelList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void insertBatchSomeColumn(List<GxYySqlxJdxxLysjRel> sqlxJdxxLysjRelList);
    /**
     * 根据sqlx删除
     * @param sqlx
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void deleteBySqlx(String sqlx);
    /**
     * 批量保存或更新
     * @param jdxxLysjRelPoList
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">dingweiwei</a>
     */
    void saveOrUpdateBatch(List<GxYySqlxJdxxLysjRel> jdxxLysjRelPoList);
    /**
     * 通过主键删除数据
     * @param plid
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    void deleteById(String plid);
}
