/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.thread;

import cn.gtmap.hlw.core.util.mdc.ThreadMdcUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class ThreadPoolMdcExecutor {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolMdcExecutor.class);
    private static Logger logger = LoggerFactory.getLogger(ThreadPoolMdcExecutor.class);
    private static Integer CORE_POOL_SSIZE = 10;
    private static Integer MAX_POOL_SSIZE = 50;
    private static Integer QUEUE_CAPACITY = 200;
    private static String THREAD_NAME_PREFIX = "myExecutor--";
    private static Integer KEEP_ALIVE_SECONDS = 60;
    private static Integer AWAIT_TERMINATION_SECONDS = 60;

    public static ThreadPoolTaskExecutor taskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(CORE_POOL_SSIZE.intValue());
        taskExecutor.setMaxPoolSize(MAX_POOL_SSIZE.intValue());
        taskExecutor.setQueueCapacity(QUEUE_CAPACITY.intValue());
        taskExecutor.setKeepAliveSeconds(KEEP_ALIVE_SECONDS.intValue());
        taskExecutor.setThreadNamePrefix(THREAD_NAME_PREFIX);
        taskExecutor.setWaitForTasksToCompleteOnShutdown(true);
        taskExecutor.setAwaitTerminationSeconds(AWAIT_TERMINATION_SECONDS.intValue());
        taskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        taskExecutor.initialize();
        return taskExecutor;
    }

    public static void execute(Runnable task) {
        ThreadPoolMdcExecutor.taskExecutor().execute(ThreadMdcUtil.wrap(task, (Map<String, String>)MDC.getCopyOfContextMap()));
    }

    public static void execute(Runnable task, boolean wait) {
        ThreadPoolTaskExecutor executor = ThreadPoolMdcExecutor.taskExecutor();
        executor.execute(ThreadMdcUtil.wrap(task, (Map<String, String>)MDC.getCopyOfContextMap()));
        if (wait) {
            ThreadPoolMdcExecutor.shutDownThread(executor);
        }
    }

    public static void shutDownThread(ThreadPoolTaskExecutor taskExecutor) {
        ThreadPoolExecutor threadPoolExecutor = taskExecutor.getThreadPoolExecutor();
        BlockingQueue<Runnable> queue = threadPoolExecutor.getQueue();
        while (true) {
            int count = threadPoolExecutor.getActiveCount();
            int queueSize = queue.size();
            if (count == 0 && queueSize == 0) break;
            log.info("\u7ebf\u7a0b\u6c60\u5c1a\u5728\u5de5\u4f5c\u4e2d\uff0c\u5f53\u524d\u89e6\u53d1{}\u4e2a\u7ebf\u7a0b\uff0c\u961f\u5217\u4e2d\u5b58\u5728{}\u4e2a\u4efb\u52a1\u6392\u961f", (Object)count, (Object)queueSize);
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                log.error("shutDownThread", (Throwable)e);
            }
        }
        taskExecutor.destroy();
    }

    public static <T> List<T> invokeAllTasks(List<Callable<T>> tasks) throws InterruptedException {
        ThreadPoolTaskExecutor executor = ThreadPoolMdcExecutor.taskExecutor();
        List<Future<T>> futures = executor.getThreadPoolExecutor().invokeAll(tasks);
        ArrayList<T> results = new ArrayList<T>();
        for (Future<T> future : futures) {
            try {
                T t = future.get();
                if (t == null) continue;
                results.add(future.get());
            }
            catch (ExecutionException e) {
                logger.error("Task execution failed: {}", (Object)e.getMessage(), (Object)e);
                if (!(e.getCause() instanceof NullPointerException)) continue;
                logger.error("NullPointerException in task", e.getCause());
            }
        }
        ThreadPoolMdcExecutor.shutDownThread(executor);
        return results;
    }
}

