package cn.gtmap.hlw.core.dto.yyxx;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/29 10:08
 * @description YyxxResultDTO
 */
@Data
public class YyxxResultDTO {
    /**预约号*/
    private String yyh;

    /**预约人标识(gx_yy_user.USER_GUID)*/
    private String yyrbs;

    /**预约人名称(gx_yy_user.REAL_NAME)*/
    private String yyrmc;

    private String yyrzjh;

    private String lxdh;

    /**预约时间*/
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date yysj;

    /**预约状态 (0:预约成功，1：取消预约,2:兑现预约)*/
    private String yyzt;

    /**预约取消时间*/
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date qxsj;

    /**登记中心代码(gx_yy_djzx.DJZXDM)*/
    private String djzxdm;

    private String djzxmc;

    /**预约时段代码(gx_yy_yysd.YYSDDM)*/
    private String yysddm;

    /**登记类型代码(gx_yy_zd_djlx.DJLXDM)*/
    private String djlxdm;
    private String djlxmc;

    private String djsx;

    /**操作时间*/
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date czsj;

    /**预约来源（1：微信，2：web,3:app）*/
    private String yyly;

    /**区域代码(gx_yy_zd_qy.QYDM)*/
    private String qydm;

    /**取消预约人(gx_yy_user.USER_GUID)*/
    private String qxyyr;

    /**预约人名称_脱敏*/
    private String yyrmcTm;

    /**预约人证件号_脱敏*/
    private String yyrzjhTm;

    /**与申请信息slbh关联*/
    private String slbh;

    /**预约人联系电话_脱敏*/
    private String lxdhTm;

    /**部门id*/
    private String orgId;

    /**合同编号或产权证号*/
    private String htbhhcqzh;

    /**合同编号*/
    private String htbh;

    /**产权证号*/
    private String cqzh;

    /** 是否委托 1是0否*/
    private String sfwt;

    /**委托人联系电话*/
    private String wtrlxdh;

    /**委托人名称*/
    private String wtrmc;

    /**委托人名称_脱敏*/
    private String wtrmcTm;

    /**委托人联系电话_脱敏*/
    private String wtrlxdhTm;

    /**不动产坐落*/
    private String zl;

    /**委托人身份证件号码*/
    private String wtrsfzjhm;

    /**委托人身份证件号码_脱敏*/
    private String wtrsfzjhmTm;

    /**审核状态（1:未审核，2：审核通过，3：审核不通过）*/
    private String shzt;

    /**审核意见*/
    private String shyj;

    /**预约分配时段*/
    private String yyfpsd;

    /** 土地证号*/
    private String tdzh;

    /**申请类型代码*/
    private String sqlxdm;

    /**上报状态(0:上报中 1 ：上报失败 2：上报成功 4：未上报)*/
    private String yysbgjyczt;

    /**上报状态(0:上报中 1 ：上报失败 2：上报成功 4：未上报)*/
    private String yyqxsbgjyczt;

    /**手机端的申请类型（关联gx_yy_menu.id）*/
    private String sqlxId;

    /**申请类型 0直接预约、1预审预约*/
    private Integer sqlx;

    /**审核人主键*/
    private String shrId;

    /**审核时间*/
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date shsj;

    /**预约时段*/
    private String yysd;

    /**业务别名*/
    private String ywbm;

    /**业务系统受理编号*/
    private String ywxtslbh;

    /**申请类型名称*/
    private String sqlxmc;

    /**起始时间*/
    private String qssj;

    /**结束时间*/
    private String jssj;
    /**同行人集合*/
    private List<YyxxTxrResultDTO> txrList;
    /**
     * 是否过期 （预约时间晚于当前时间）
     */
    private String sfgq;
    /**
     * 预约配置id
     */
    private String yypzId;
    /**
     * 验证码
     */
    private String yzm;
    /**
     * 预约地址
     */
    private String yydz;
    /**预约上门时间*/
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date yysmsj;
    /**
     * 预约附件信息
     */
    private List<YyFjxxDTO> fjxxList;
}
