/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.jwt;

import cn.gtmap.hlw.core.base.UserInfo;
import cn.gtmap.hlw.core.enums.error.TokenErrorEnum;
import cn.gtmap.hlw.core.exception.TokenException;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import cn.gtmap.hlw.core.util.thread.ThreadLocalUtils;
import com.alibaba.fastjson.JSON;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.collect.Maps;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Jwt {
    private static int expireDate;
    private static String SECRET;

    public static int getExpireDate() {
        return expireDate;
    }

    public static void setExpireDate(int expireDate) {
        Jwt.expireDate = expireDate;
    }

    public static String creatToken(Map<String, String> map) {
        JWTCreator.Builder builder = JWT.create();
        map.forEach((k, v) -> builder.withClaim(k, v));
        Calendar instance = Calendar.getInstance();
        instance.add(12, expireDate);
        builder.withExpiresAt(instance.getTime());
        return builder.sign(Algorithm.HMAC256((String)SECRET));
    }

    public static void verify(String token) {
        JWT.require((Algorithm)Algorithm.HMAC256((String)SECRET)).build().verify(token);
    }

    public static DecodedJWT getToken(String token) {
        return JWT.require((Algorithm)Algorithm.HMAC256((String)SECRET)).build().verify(token);
    }

    public static Map<String, String> getPayload(String token) {
        HashMap map = Maps.newHashMap();
        DecodedJWT decode = JWT.decode((String)token);
        Map claimMap = decode.getClaims();
        if (Objects.isNull(claimMap)) {
            throw new TokenException(TokenErrorEnum.EMPTY_TOKEN_ERROR);
        }
        for (Map.Entry entry : claimMap.entrySet()) {
            map.put(entry.getKey(), decode.getClaim((String)entry.getKey()).asString());
        }
        Object userInfo = BeanConvertUtil.convertMap(map, UserInfo.class);
        ThreadLocalUtils.set("userInfo", userInfo);
        return map;
    }

    public static void main(String[] args) {
        String token = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzZnl6IjoiWSIsImx4RGgiOiIxMzIzNTI3MDY3OSIsIm9yZ0ZkZGJyZGgiOiIiLCJxeWRtIjoiIiwib3JnRmRkYnIiOiIiLCJ1c2VyUHdkIjoiIiwidXNlclpqaWRUbSI6IioqKioqKioqKioqKioqKioqWCIsIm9yZ0lkIjoiNTlTMDMzMTM5SzYzRjFIUiIsInloenhkeiI6IiIsImx4RGhUbSI6IioqKioqKioqKio5Iiwic2Z5cXpxeCI6IiIsInNmeWoiOiIwIiwib3JnVHl4eWRtVG0iOiIqKioqKioqKioqKioqKioqKkIiLCJvcmdGZGRicnpqaFRtIjoiIiwidXNlclpqaWQiOiIzMjEwMDIxOTcyMDIyMzEyMlgiLCJzeXNJcCI6IiIsIm53d2JzIjoiMiIsIm9yZ1N6c2hlbmciOiIiLCJvcmdReWRtIjoiMzIxMDAwIiwiZXhwIjoxNzQ5NzMzODIzLCJvcmdOYW1lVG0iOiIiLCJvcmdTenNoaSI6IiIsIm9yZ1R5eHlkbSI6IjkxMzIxMDAzNzk4NjMxMzdYQiIsIm9yZ0ZkZGJyempoIjoiIiwib3JnTmFtZSI6Iuaxn-iLj-mTtuihjOiCoeS7veaciemZkOWFrOWPuOaJrOW3nuWIhuihjCIsInJvbGVJZCI6IjUiLCJ6alR5cGUiOiIxIiwicmVhbE5hbWVUbSI6IirombkiLCJvcmdTenhpYW4iOiIiLCJ1c2VyR3VpZCI6ImQ5OGQwNTQzODlkYTQ0ZTNiYmJjZTBlYjk4NWVlZjBjIiwidXNlck5hbWUiOiJ5aG0wNjc5NzU5NzI5Iiwib3JnRmRkYnJ6amx4IjoiIiwidG9rZW4iOiIiLCJyZWFsTmFtZSI6IuS4geiZuSIsIm9yZ1pqbHgiOiI4IiwiY3l6enpoIjoiIiwiZXhwaXJlIjoiIiwicm9sZU5hbWUiOiLmgLvooYznrqHnkIblkZgiLCJvcmdGZGRiclRtIjoiIiwib3JnRmRkYnJkaFRtIjoiIiwib3JnTHhkaCI6IiJ9.pCSarbVv161ulJjze6ONECWIm50lL-RE-GTuAqIqyY8";
        Map<String, String> user = Jwt.getPayload(token);
        System.out.println(JSON.toJSONString(user));
    }

    static {
        SECRET = "lww9227wxb1992hyk920709sl017zp17";
    }
}

