package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author： admin
 * @Data: 2020/12/4
 * @Description: 新闻类型
 */
@Getter
@AllArgsConstructor
public enum NewsTypeEnum {

    /**房屋租赁 */
    NEWS_TYPE_FWZL("100","房屋租赁"),
    /** 房屋交易*/
    NEWS_TYPE_FWJY("200","房屋交易"),
    /**政策法规 */
    NEWS_TYPE_ZCFG("300","政策法规"),
    /** 通知公告*/
    NEWS_TYPE_TZGG("400","通知公告"),
    /** 通知公告*/
    NEWS_TYPE_YSBZ("401","遗失补证"),
    /** 通知公告*/
    NEWS_TYPE_JC("402","继承"),
    /** 通知公告*/
    NEWS_TYPE_ZX("403","注销"),
    /** 通知公告*/
    NEWS_TYPE_GG("406","公告"),
    /** 通知公告*/
    NEWS_TYPE_BSZL("407","办事指南"),
    /**操作指南 */
    NEWS_TYPE_GSGG("500","公示公告"),

    /**所属类型（0:所有，1：微信，2：web）*/
    WX_TYPE("1","微信"),
    /**所属类型（0:所有，1：微信，2：web）*/
    WEB_TYPE("2","web"),
    /**所属类型（0:所有，1：微信，2：web）*/
    ALL_TYPE("0","web");

    @Getter
    private String code;

    @Getter
    private String msg;

    public static String getMsg(String code) {
        for (NewsTypeEnum xq : NewsTypeEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
