package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.BasePage;
import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.user.org.OrgListQueryParamsDTO;
import cn.gtmap.hlw.core.model.GxYyOrg;

import java.util.List;
import java.util.Map;

/**
 * (GxYyOrg)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
public interface GxYyOrgRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param orgId 主键
     * @return 实例对象
     */
    GxYyOrg get(String orgId);

    /**
     * 通过userid查询部门
     *
     * @param userid 用户id
     * @return 实例对象
     */
    GxYyOrg getOrgByUserid(String userid);

    /**
     * 根据统一信用代码查询公司
     *
     * @param tyxydm 统一信用代码
     * @return 实例对象
     */
    GxYyOrg getByTyxydm(String tyxydm);

    GxYyOrg getByTyxydm(String tyxydm, String orgName);

    /**
     * 通过ID查询单条数据
     *
     * @param orgList
     * @param qydmList
     * @return 实例对象
     */
    List<GxYyOrg> getByOrgListAndQydmList(List<String> orgList, List<String> qydmList);

    /**
     * 通过ID查询数据
     *
     * @param orgId
     * @return 实例对象
     */
    List<GxYyOrg> getOrgAndChilds(String orgId);

    /**
     * 新增数据
     *
     * @param gxYyOrg 实例对象
     * @return 影响行数
     */
    String save(GxYyOrg gxYyOrg);

    String saveOrUpdateOrg(GxYyOrg gxYyOrg);

    /**
     * 修改数据
     *
     * @param gxYyOrg 实例对象
     * @return 影响行数
     */
    void update(GxYyOrg gxYyOrg);

    /**
     * 根据统一信用代码查询部门信息
     *
     * @param tyxydm 统一信用代码
     * @return:Map
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    Map queryBmByTyxydm(String tyxydm);

    /**
     * 根据统一信用代码查询部门信息
     *
     * @param qlrzjhList 统一信用代码
     * @return:Map
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<Map> queryBmByTyxydmList(List<String> qlrzjhList);

    /**
     * 根据部门id获取所管辖的区域代码
     *
     * @param orgId
     * @return
     */
    List<String> queryQydmByOrgId(String orgId);

    List<GxYyOrg> getByOrgIdList(List<String> orgIdList);

    /**
     * 获取数据
     *
     * @return 影响行数
     */
    List<GxYyOrg> getAll();

    /**
     * 获取数据
     *
     * @param orgName 企业名称
     * @return GxYyOrg集合
     */
    List<GxYyOrg> getListByOrgName(String orgName);

    /**
     * 删除数据
     *
     * @param orgId
     * @return 影响行数
     */
    int delete(String orgId);

    /**
     * 分页查询
     *
     * @param orgId   公司id
     * @param orgName 公司名称
     * @param page
     * @return 影响行数
     */
    PageInfo<GxYyOrg> queryPage(String orgId, String orgName, BasePage page);

    /**
     * 根据统一信用代码查询
     *
     * @param qlrzjhList
     * @return:List<GxYyOrg>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyOrg> listByTyxydm(List<String> qlrzjhList);

    PageInfo<GxYyOrg> queryPage(OrgListQueryParamsDTO paramsDTO);

    void updateShzt(String orgId, String shzt);
}

