/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.encryption;

import cn.gtmap.hlw.core.base.ApiEncryptBody;
import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import cn.gtmap.hlw.core.util.encryption.sm4.Sm4Util;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiSecurityUtils {
    private static final Logger log = LoggerFactory.getLogger(ApiSecurityUtils.class);

    public static String decrypt(String sm4KeyBySm2, String decryptStr) {
        String sm4Key = Sm2lib.decode(sm4KeyBySm2);
        return Sm4Util.decryptEcb(sm4Key, decryptStr);
    }

    public static ApiEncryptBody encrypt(String encryptStr, String frontPublicKey) throws Exception {
        String sm4Key = Sm4Util.generateKey();
        String data = Sm4Util.encryptEcb(sm4Key, encryptStr);
        ApiEncryptBody apiEncryptRes = new ApiEncryptBody();
        apiEncryptRes.setParamid(Sm2lib.encode(sm4Key, frontPublicKey));
        apiEncryptRes.setData(data);
        apiEncryptRes.setFrontKey(frontPublicKey);
        return apiEncryptRes;
    }

    public static void main(String[] args) throws Exception {
        String pubKey = "c2f1831616943efe504bde6b45d59eea953f04d31ecebd4c59dffd6733c7a066c7a9c14cb2c54564187891f72753fea7f56d07b19d52e9076263564def41b8e7";
        String dataEncrypt = "de21ace72ab46cde2fb7288a897ce26ca4e989b052cbb9dc0d70b780f7777416fe75f1f7eaf47062252bdd68fb521183b9f9f58c511ed467edc20030320a84d0409a391b61a5381339b7dea07bf3aea3d0c7a0ab860456d1414243f7c6a7ac9b69745ff6fb664d8954737f0db823014f645e80131e333e24d0cbcf7fda52757b54580655e907b7a91e8ef578d68ae55c57cf5aedd2202b6b325e995d284bb6630f51854e1d0411a80fd2a77a8844a9942d2482a8daa938f5afb1a946aa3e5d207f58368e6387dbb9a4f77b471d3b032c579cb73eb919a3eb5b92981d30ac9f3d12718354fadec3663b6ea3b12574f6eb67b5ecd1264c5259f6b8ecd084e87edf2a514963f8e1860986de55cfe6bf761355a7fa30be5333aa68b86455e20a94e9ffc86d2686b90485ed8ab93d2226f2000723c5b264f2a693fbcd05f3b7a5293c";
        String paramid = "0430b82605de8a296cb0d09bd478937a232d499ef125b94fcb24e5350142e533e065d749a42d5db3dae59e75b1fffa7d8963acdd473943009a7b715458d129d7cb85220cb55b6b833baee3925178eb2be9ae33dfc9f4723b7b99d0e38d87eaec7884bcfba461d2a7fc03ee8ef9eff76c8f4de5bbfc5f0e10b6f6ef68940adbc9be8f2cb36ec580e3e0603bcd84";
        String qdData = ApiSecurityUtils.decrypt(paramid, dataEncrypt);
        System.out.println(qdData);
        String sm4Key = "B13356B451572BFC3478AC20F0E3E163";
        String encryptStr = "{\"sqid\":\"\",\"qlrmc\":\"\u5468\u5efa\u98de\",\"qlrzjh\":\"340823199406243115\"}";
        String data = Sm4Util.encryptEcb(sm4Key, encryptStr);
        String paramid2 = Sm2lib.encode(sm4Key);
        ApiEncryptBody body = new ApiEncryptBody();
        body.setData(data);
        body.setParamid(paramid2);
        body.setFrontKey(pubKey);
        System.out.println(JSON.toJSONString((Object)body));
    }
}

