package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author： admin
 * @Data: 2020/12/4
 * @Description: 角色
 */
@Getter
@AllArgsConstructor
public enum RoleEnum {

    /** 管理员 */
    BDGL_ROLE_GLY("1","管理员"),
    /**
     * 分级管理员
     */
    BDGL_ROLE_FJGLY("101","分级管理员"),
    /**
     * 中心管理员
     */
    BDGL_ROLE_ZXGLY("102","中心管理员"),
    /** 个人 */
    BDGL_ROLE_GR("2","自然人"),
    /** 中介 */
    BDGL_ROLE_ZJ("3","中介"),
    /** 行政单位 */
    BDGL_ROLE_KFS("4","开发商"),
    /** 银行 */
    BDGL_ROLE_YH("5","银行"),
    /** 单位 */
    BDGL_ROLE_DW("6","单位"),

    /**
     * 支行管理员
     */
    BDGL_ROLE_DW_ZHGLY("501","支行管理员"),
    /**
     * 支行一般代理人
     */
    BDGL_ROLE_DW_ZHYBDLR("502","支行一般代理人"),
    /**
     * 银行预审
     */
    BDGL_ROLE_DW_YHYS("503","银行预审"),
    /**
     * 银行盖章
     */
    BDGL_ROLE_DW_YHGZ("504","银行盖章"),
    /**
     * 银行复审
     */
    BDGL_ROLE_DW_YHFS("505","银行复审"),
    /**
     * 破产管理审核
     */
    BDGL_ROLE_DW_PCGLSH("1101","破产管理审核"),
    /**
     * 水务审核角色
     */
    BDGL_ROLE_DW_SWSH("601","水务审核"),
    /**
     * 电务审核角色
     */
    BDGL_ROLE_DW_DWSH("602","电务审核"),
    /**
     * 燃气审核角色
     */
    BDGL_ROLE_DW_RQSH("603","燃气审核"),
    /**
     * 广电审核角色
     */
    BDGL_ROLE_DW_GDSH("607","广电审核"),
    /**
     * 网络公司审核角色
     */
    BDGL_ROLE_DW_WLGSSH("608","网络公司审核"),
    /** 破产管理人 */
    BDGL_ROLE_PCGLR("7","破产管理人"),
    /** 分中心预审角色 */
    BDGL_ROLE_FZXYSJS("8","分中心预审角色"),
    /** 分中心预审角色 */
    BDGL_ROLE_FYRY("9","防疫人员"),
    /** 分中心预审角色 */
    BDGL_ROLE_SFJG("10","司法机关"),
    /** 泰兴税务角色 */
    BDGL_ROLE_SW("11","税务角色"),
    /** 市级法院（查、控） */
    BDGL_ROLE_SJFY("12","市级法院（查、控）"),
    /** 县级法院（查、控） */
    BDGL_ROLE_XJFY("13","县级法院（查、控）"),
    /** 便民服务中心 */
    BDGL_ROLE_BMFWZX("14","便民服务中心"),
    /**
     * 登记中心一窗受理  一窗代办
     */
    BDGL_ROLE_YCSL("15","一窗受理"),
    /**
     * 代办企业
     */
    BDGL_ROLE_DBQY("16","代办企业"),
    /**
     * 登记机构预审-扬州
     */
    BDGL_ROLE_DJJGYS("555","一窗受理"),
    /**
     * 拆迁办
     */
    BDGL_ROLE_CQB("17","拆迁办"),
    /**
     * 打证员(打证系统)角色
     */
    BDGL_ROLE_DZY("18","打证员"),
    /**
     * 登记机构 后续合并成 15
     */
    BDGL_ROLE_DJJG("19","登记机构"),
    /**
     * 用户角色-民政局
     */
    BDGL_ROLE_MZJ("20","民政局"),
    /**
     * 用户角色-保障房中心
     */
    BDGL_ROLE_BZFZX("21","保障房中心"),
    /**
     * 用户角色-政务法人
     */
    BDGL_ROLE_ZWFR("444","政务法人");

    @Getter
    private String code;

    @Getter
    private String msg;

    public static String getMsg(String code) {
        for (RoleEnum xq : RoleEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }

}
