package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxSpxx;

import java.util.List;
import java.util.Map;

/**
 * (GxYySqxxSpxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:43
 */
public interface GxYySqxxSpxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param spid 主键
     * @return 实例对象
     */
    GxYySqxxSpxx get(String spid);

    /**
     * 新增数据
     *
     * @param gxYySqxxSpxx 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxSpxx gxYySqxxSpxx);

    /**
     * 修改数据
     *
     * @param gxYySqxxSpxx 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxSpxx gxYySqxxSpxx);

    /**
     * 通过sqidList查询集合数据
     *
     * @param sqidList
     * @return 实例对象
     */
    List<GxYySqxxSpxx> getBySqidList(List<String> sqidList);

    /**
     * 通过sqidList删除数据
     *
     * @param sqidList
     * @return 实例对象
     */
    int deleteBySqidList(List<String> sqidList);

    /**
     * 通过slbh查询数据
     *
     * @param slbh
     * @return 实例对象
     */
    GxYySqxxSpxx getBySlbh(String slbh);

    /**
     * 通过slbh,sjly集合查询数据
     *
     * @param slbh     受理编号
     * @param sjlyList 数据来源集合
     * @return 实例对象
     */
    List<GxYySqxxSpxx> getBySlbhAndSjlyList(String slbh, List<String> sjlyList);

    /**
     * 通过slbh查询数据
     *
     * @param ghxxId
     * @return 实例对象
     */
    GxYySqxxSpxx getByGhxxId(String ghxxId);

    /**
     * 保存或更新
     *
     * @param gxYySqxxSpxx 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYySqxxSpxx gxYySqxxSpxx);

    /**
     * 批量保存或更新
     *
     * @param gxYySqxxSpxxList 实例对象
     * @return 影响行数
     */
    void saveOrUpdateBatch(List<GxYySqxxSpxx> gxYySqxxSpxxList);

    /**
     * 根据map查询
     *
     * @param paramMap
     * @return:List<GxYySqxxSpxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYySqxxSpxx> getListByMap(Map<String, Object> paramMap);

    /**
     * 通过slbh,spzt,sjly集合查询数据
     *
     * @param slbh     受理编号
     * @param spzt     审批状态
     * @param sjlyList 数据来源集合
     * @return: List<GxYySqxxSpxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYySqxxSpxx> getBySlbhAndSpztAndSjlyList(String slbh,String spzt, List<String> sjlyList);

    /**
     * 通过slbh,spzt,sjly集合查询数据
     *
     * @param slbh     受理编号
     * @param spzt     审批状态
     * @param sjly 数据来源
     * @return: List<GxYySqxxSpxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYySqxxSpxx getBySlbhAndSpztAndSjly(String slbh,String spzt, String sjly);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 获取审批信息更加审批时间排序
     */
    List<GxYySqxxSpxx> getSpxxBySlbh(String slbh);
    /**
     * 通过slbh,sjly集合查询数据
     * @param slbh
     * @param sjly
     * @return:java.util.List<cn.gtmap.hlw.core.model.GxYySqxxSpxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYySqxxSpxx> getBySlbhAndSjly(String slbh, String sjly);
    /**
     * 根据slbh和sjly删除
     * @param slbh
     * @param sjly
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteBySlbhAndSjly(String slbh, String sjly);
}

