package cn.gtmap.hlw.core.util.encryption;

import cn.gtmap.hlw.core.base.ApiEncryptBody;
import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import cn.gtmap.hlw.core.util.encryption.sm4.Sm4Util;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;

import java.text.DecimalFormat;

/**
 * @Author jianglin
 * @Date 2024/6/27
 * @Description 接口出入参-加解密-工具类
 */
@Slf4j
public class ApiSecurityUtils {

    /**
     * @param sm4KeyBySm2 经过Sm2加密的sm4key
     * @param decryptStr  经过sm4加密的数据
     * @return 解密后的数据
     */
    public static String decrypt(String sm4KeyBySm2, String decryptStr) {
        String sm4Key = Sm2lib.decode(sm4KeyBySm2);
        return Sm4Util.decryptEcb(sm4Key, decryptStr);
    }

    /**
     * @param encryptStr     要加密的数据
     * @param frontPublicKey 前端公钥
     * @return 加密后的数据
     */
    public static ApiEncryptBody encrypt(String encryptStr, String frontPublicKey) throws Exception {
        //生成一个随机的sm4加密key
        String sm4Key = Sm4Util.generateKey();
        //加密
        String data = Sm4Util.encryptEcb(sm4Key, encryptStr);
        ApiEncryptBody apiEncryptRes = new ApiEncryptBody();
        //用前端公钥(用前端的公钥)，sm2加密sm4Key
        apiEncryptRes.setParamid(Sm2lib.encode(sm4Key, frontPublicKey));
        apiEncryptRes.setData(data);
        apiEncryptRes.setFrontKey(frontPublicKey);
        return apiEncryptRes;
    }

    //加解密测试
    public static void main(String[] args) throws Exception {
        String pubKey = "c2f1831616943efe504bde6b45d59eea953f04d31ecebd4c59dffd6733c7a066c7a9c14cb2c54564187891f72753fea7f56d07b19d52e9076263564def41b8e7";

        //前端入参 解密
        String dataEncrypt = "7cc940b9ed5e6a8867f41915d2250d670aa37833134eeb0a018b78d3b33b4fe3eac1bdee048ddfdfc263a89964680fbf7b8e1aa9e6896599ee8e6bb1facecbf0";
        String paramid = "0402bd55a91fe4b5f677967d54303cd848f5f1bdb213784247c63b0634fee841aa00ac185d5fb6ffad003444f791c69c545289b77b43c9bcfdc42b02f264bab27071eac38d85446b20bf83f3b56e27591760940cdb0271919576ba0f4c417c80095a4d9fbc4713639eb533e2ba23c34bc258bad990de185360388c74570ac93ec17f656fe4f9e5185dc37c658a";
        String qdData = ApiSecurityUtils.decrypt(paramid, dataEncrypt);
        System.out.println(qdData);


        //生成前端加密密文
        //生成一个随机的sm4加密key
        String sm4Key = "B13356B451572BFC3478AC20F0E3E163";
        //前端入参
        String encryptStr = "{\"cqzh\":\"皖(2018)芜湖市不动产权第0569026号\",\"xmid\":\"WHFDCQ17305628200521664614\"}";
        //加密
        String data = Sm4Util.encryptEcb(sm4Key, encryptStr);
        String paramid2 = Sm2lib.encode(sm4Key);

        ApiEncryptBody body = new ApiEncryptBody();
        body.setData(data);
        body.setParamid(paramid2);
        body.setFrontKey(pubKey);

        System.out.println(JSON.toJSONString(body));
    }

}
