package cn.gtmap.hlw.core.dto.sqxx.push.dj2.sqxx;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2023/7/10
 * @description 通用项目创建接口入参（登记2.0）
 */
@Data
public class PushSqxxDTO {
    /**
     * 业务号
     */
    private String ywh;
    /**
     * 申请登记类型
     */
    private String sqdjlx;
    /**
     * 是否自动创建，1自动创建，0手动创建
     */
    private String sfcj;
    /**
     * 预约部门编码
     */
    private String yybmbm;
    /**
     * 证书来源
     */
    private String zsly;
    /**
     * 申请人id
     */
    private String sqrid;
    /**
     * 特殊标记
     */
    private String tsbj;
    /**
     * 创建人角色名称
     */
    private String cjrjsmc;
    /**
     * 房源编号
     */
    private String fybh;
    /**
     * 申请人证件号
     */
    private String sqrzjh;
    /**
     * 登记子项
     */
    private String djzx;
    /**
     * 受理来源
     */
    private String slly;
    /**
     * 申请人名称
     */
    private String sqrmc;
    /**
     * 自动转发
     */
    private String zdzf;
    /**
     * 满意度
     */
    private String myd;
    /**
     * 评价内容
     */
    private String pjnr;
    /**
     * 一窗受理人名称
     */
    private String ycslrmc;
    /**
     * 一窗受理人部门名称
     */
    private String ycslrbmmc;

    @ZdDzConfig(field = "bdcdyxx", tableName = "", isList = true)
    private List<PushSqxxBdcdyxxDTO> bdcdyxx;

    /**
     * 是否组合流程
     */
    private Boolean sfzh;
    /**
     * 是否公告
     */
    private String sfgg;
    /**
     * 是否收回证书
     */
    private String sfshzs;
    /**
     * 创建人角色id
     */
    private String cjrjsid;
    /**
     * 创建人名称
     */
    private String cjrmc;
    /**
     * 申请来源
     */
    private String sqly;
}
